/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.configurate.yaml;

import java.io.BufferedReader;
import java.io.Writer;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.configurate.CommentedConfigurationNode;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.ConfigurationOptions;
import org.spongepowered.configurate.loader.AbstractConfigurationLoader;
import org.spongepowered.configurate.loader.CommentHandler;
import org.spongepowered.configurate.loader.CommentHandlers;
import org.spongepowered.configurate.loader.LoaderOptionSource;
import org.spongepowered.configurate.util.UnmodifiableCollections;
import org.spongepowered.configurate.yaml.NodeStyle;
import org.spongepowered.configurate.yaml.internal.snakeyaml.DumperOptions;
import org.spongepowered.configurate.yaml.internal.snakeyaml.LoaderOptions;
import org.spongepowered.configurate.yaml.internal.snakeyaml.Yaml;
import org.spongepowered.configurate.yaml.internal.snakeyaml.constructor.BaseConstructor;
import org.spongepowered.configurate.yaml.internal.snakeyaml.constructor.Constructor;
import org.spongepowered.configurate.yaml.internal.snakeyaml.representer.Representer;

public final class YamlConfigurationLoader
extends AbstractConfigurationLoader<CommentedConfigurationNode> {
    private static final Set<Class<?>> NATIVE_TYPES = UnmodifiableCollections.toSet((Object[])new Class[]{Boolean.class, Integer.class, Long.class, BigInteger.class, Double.class, byte[].class, String.class, java.util.Date.class, Date.class, Timestamp.class});
    private final ThreadLocal<Yaml> yaml;

    public static Builder builder() {
        return new Builder();
    }

    private YamlConfigurationLoader(Builder builder) {
        super((AbstractConfigurationLoader.Builder)builder, new CommentHandler[]{CommentHandlers.HASH});
        LoaderOptions loaderOpts = new LoaderOptions().setAcceptTabs(true).setProcessComments(false);
        loaderOpts.setCodePointLimit(Integer.MAX_VALUE);
        DumperOptions opts = builder.options;
        opts.setDefaultFlowStyle(NodeStyle.asSnakeYaml(builder.style));
        this.yaml = ThreadLocal.withInitial(() -> new Yaml((BaseConstructor)new Constructor(loaderOpts), new Representer(opts), opts, loaderOpts));
    }

    protected void loadInternal(CommentedConfigurationNode node, BufferedReader reader) {
        node.raw(this.yaml.get().load(reader));
    }

    protected void saveInternal(ConfigurationNode node, Writer writer) {
        this.yaml.get().dump(node.raw(), writer);
    }

    public CommentedConfigurationNode createNode(ConfigurationOptions options) {
        return CommentedConfigurationNode.root((ConfigurationOptions)options);
    }

    public static final class Builder
    extends AbstractConfigurationLoader.Builder<Builder, YamlConfigurationLoader> {
        private final DumperOptions options = new DumperOptions();
        private @Nullable NodeStyle style;

        Builder() {
            this.indent(4);
            this.defaultOptions(o -> o.nativeTypes(NATIVE_TYPES));
            this.from(DEFAULT_OPTIONS_SOURCE);
        }

        protected void populate(LoaderOptionSource options) {
            @Nullable NodeStyle declared = (NodeStyle)options.getEnum(NodeStyle.class, new String[]{"yaml", "node-style"});
            if (declared != null) {
                this.style = declared;
            }
        }

        public Builder indent(int indent) {
            this.options.setIndent(indent);
            return this;
        }

        public int indent() {
            return this.options.getIndent();
        }

        public Builder nodeStyle(@Nullable NodeStyle style) {
            this.style = style;
            return this;
        }

        public @Nullable NodeStyle nodeStyle() {
            return this.style;
        }

        public YamlConfigurationLoader build() {
            return new YamlConfigurationLoader(this);
        }
    }
}

