/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import org.bukkit.Art;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Painting;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.bukkit.event.hanging.HangingBreakEvent;
import org.bukkit.event.hanging.HangingPlaceEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Main
extends JavaPlugin
implements Listener {
    private File paintingsFile;
    private FileConfiguration paintingsConfig;
    private Set<Location> restoredPaintingLocations = new HashSet<Location>();

    public void onEnable() {
        this.setupConfig();
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
        Bukkit.getScheduler().runTaskLater((Plugin)this, this::restorePaintings, 20L);
        this.getLogger().info("DLQuadro habilitado!");
    }

    public void onDisable() {
        this.getLogger().info("DLQuadro desabilitado!");
    }

    private void setupConfig() {
        this.paintingsFile = new File(this.getDataFolder(), "paintings.yml");
        if (!this.paintingsFile.exists()) {
            try {
                this.paintingsFile.getParentFile().mkdirs();
                if (this.paintingsFile.createNewFile()) {
                    this.getLogger().info("Criado arquivo paintings.yml");
                }
            }
            catch (IOException e) {
                this.getLogger().log(Level.SEVERE, "N\u00e3o foi poss\u00edvel criar o arquivo paintings.yml!", e);
            }
        }
        this.paintingsConfig = YamlConfiguration.loadConfiguration((File)this.paintingsFile);
        if (!this.paintingsConfig.isConfigurationSection("paintings")) {
            this.paintingsConfig.createSection("paintings");
            this.savePaintingsData();
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onHangingPlace(HangingPlaceEvent event) {
        if (event.getEntity() instanceof Painting) {
            Painting painting = (Painting)event.getEntity();
            Location location = painting.getLocation();
            Art art = painting.getArt();
            BlockFace facing = painting.getFacing();
            String locationString = this.serializeLocation(location);
            String path = "paintings." + locationString;
            this.paintingsConfig.set(path + ".world", (Object)location.getWorld().getName());
            this.paintingsConfig.set(path + ".art", (Object)art.name());
            this.paintingsConfig.set(path + ".facing", (Object)facing.name());
            this.savePaintingsData();
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onHangingBreak(HangingBreakEvent event) {
        if (event.getEntity() instanceof Painting) {
            Painting painting = (Painting)event.getEntity();
            Location location = painting.getLocation();
            String locationString = this.serializeLocation(location);
            if (this.paintingsConfig.contains("paintings." + locationString)) {
                this.paintingsConfig.set("paintings." + locationString, null);
                this.savePaintingsData();
                this.getLogger().info("Registro da pintura removido de " + locationString + " (Causa: " + event.getCause().name() + ")");
                this.restoredPaintingLocations.remove(location);
            }
            if (event instanceof HangingBreakByEntityEvent) {
                HangingBreakByEntityEvent entityEvent = (HangingBreakByEntityEvent)event;
                Entity entity = entityEvent.getRemover();
            }
        }
    }

    private void restorePaintings() {
        this.getLogger().info("Restaurando pinturas salvas...");
        ConfigurationSection paintingsSection = this.paintingsConfig.getConfigurationSection("paintings");
        if (paintingsSection == null || paintingsSection.getKeys(false).isEmpty()) {
            this.getLogger().info("Nenhuma pintura encontrada para restaurar.");
            return;
        }
        int restoredCount = 0;
        int skippedCount = 0;
        int errorCount = 0;
        for (String key : paintingsSection.getKeys(false)) {
            BlockFace facing;
            Art art;
            String path;
            Location location = this.deserializeLocation(key, this.paintingsConfig.getString((path = "paintings." + key) + ".world"));
            if (location == null || location.getWorld() == null) {
                this.getLogger().warning("N\u00e3o foi poss\u00edvel desserializar ou encontrar o mundo para a localiza\u00e7\u00e3o: " + key);
                ++errorCount;
                continue;
            }
            if (!location.getChunk().isLoaded()) continue;
            boolean alreadyExists = false;
            for (Entity entity : location.getChunk().getEntities()) {
                if (!(entity instanceof Painting) || !entity.getWorld().equals((Object)location.getWorld()) || entity.getLocation().getBlockX() != location.getBlockX() || entity.getLocation().getBlockY() != location.getBlockY() || entity.getLocation().getBlockZ() != location.getBlockZ()) continue;
                this.getLogger().fine("Pintura j\u00e1 existe (verifica\u00e7\u00e3o de bloco) em " + key + ", pulando restaura\u00e7\u00e3o.");
                alreadyExists = true;
                break;
            }
            if (alreadyExists) {
                this.restoredPaintingLocations.add(location);
                ++skippedCount;
                continue;
            }
            try {
                art = Art.valueOf((String)this.paintingsConfig.getString(path + ".art"));
                facing = BlockFace.valueOf((String)this.paintingsConfig.getString(path + ".facing"));
            }
            catch (IllegalArgumentException | NullPointerException e) {
                this.getLogger().warning("Dados inv\u00e1lidos para pintura em " + key + ": " + e.getMessage());
                ++errorCount;
                continue;
            }
            Block attachedBlock = location.getBlock().getRelative(facing.getOppositeFace());
            if (attachedBlock == null || !attachedBlock.getType().isSolid()) {
                this.getLogger().warning("Bloco de suporte ausente ou n\u00e3o s\u00f3lido para pintura em " + key + ". N\u00e3o foi poss\u00edvel restaurar.");
                ++errorCount;
                continue;
            }
            World world = location.getWorld();
            Painting spawnedPainting = null;
            try {
                spawnedPainting = (Painting)world.spawn(location, Painting.class);
                if (spawnedPainting != null) {
                    spawnedPainting.setArt(art);
                    spawnedPainting.setFacingDirection(facing);
                    this.getLogger().info("Pintura (SEM LAMBDA) '" + art.name() + "' restaurada em " + key);
                    this.restoredPaintingLocations.add(location);
                    ++restoredCount;
                } else {
                    this.getLogger().warning("Spawn (SEM LAMBDA) retornou null para pintura em " + key);
                    ++errorCount;
                }
            }
            catch (Exception e) {
                this.getLogger().log(Level.SEVERE, "Exce\u00e7\u00e3o durante spawn/modify (SEM LAMBDA) para pintura em " + key, e);
                ++errorCount;
            }
            this.getLogger().info("Pintura '" + art.name() + "' restaurada (ou tentativa iniciada) em " + key);
            this.restoredPaintingLocations.add(location);
            ++restoredCount;
        }
        this.getLogger().info("Restaura\u00e7\u00e3o de pinturas conclu\u00edda. Tentativas: " + restoredCount + ", J\u00e1 existentes/Puladas: " + skippedCount + ", Erros: " + errorCount);
    }

    private void savePaintingsData() {
        try {
            this.paintingsConfig.save(this.paintingsFile);
        }
        catch (IOException e) {
            this.getLogger().log(Level.SEVERE, "N\u00e3o foi poss\u00edvel salvar o arquivo paintings.yml!", e);
        }
    }

    private String serializeLocation(Location location) {
        return location.getWorld().getName() + "_" + location.getBlockX() + "_" + location.getBlockY() + "_" + location.getBlockZ();
    }

    private Location deserializeLocation(String serializedKey, String worldName) {
        if (worldName == null || worldName.isEmpty()) {
            this.getLogger().warning("Nome do mundo ausente para a chave: " + serializedKey);
            return null;
        }
        World world = Bukkit.getWorld((String)worldName);
        if (world == null) {
            this.getLogger().warning("Mundo '" + worldName + "' n\u00e3o encontrado para a chave: " + serializedKey);
            return null;
        }
        String coordsPart = serializedKey.substring(worldName.length() + 1);
        String[] parts = coordsPart.split("_");
        if (parts.length != 3) {
            this.getLogger().warning("Formato inv\u00e1lido para coordenadas na chave: " + serializedKey);
            return null;
        }
        try {
            int x = Integer.parseInt(parts[0]);
            int y = Integer.parseInt(parts[1]);
            int z = Integer.parseInt(parts[2]);
            return new Location(world, (double)x, (double)y, (double)z);
        }
        catch (NumberFormatException e) {
            this.getLogger().warning("Erro ao converter coordenadas para n\u00fameros na chave: " + serializedKey);
            return null;
        }
    }
}

