/*
 * Decompiled with CFR 0.152.
 */
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class Main
extends JavaPlugin
implements Listener {
    private final HashMap<UUID, Area> playerAreas = new HashMap();
    private final HashMap<UUID, AreaBuilder> tempSelections = new HashMap();
    private String webhookUrl;

    public void onEnable() {
        this.webhookUrl = this.getConfig().getString("webhook_url");
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getCommand("setarea").setExecutor((CommandExecutor)this);
        this.getCommand("dlrandom").setExecutor((CommandExecutor)this);
        this.loadAreas();
        this.getLogger().info("DLRandomV3 ativado.");
    }

    public void onDisable() {
        this.saveAllAreas();
        this.getLogger().info("DLRandomV3 desativado.");
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (command.getName().equalsIgnoreCase("setarea")) {
            if (!(sender instanceof Player)) {
                sender.sendMessage("\u00a7cApenas jogadores podem usar este comando.");
                return true;
            }
            Player player = (Player)sender;
            if (!player.isOp()) {
                player.sendMessage("\u00a7cApenas operadores podem usar este comando.");
                return true;
            }
            if (args.length != 1) {
                player.sendMessage("\u00a7cUso correto: /setarea <player>");
                return true;
            }
            Player target = Bukkit.getPlayer((String)args[0]);
            if (target == null) {
                player.sendMessage("\u00a7cJogador n\u00e3o encontrado ou offline.");
                return true;
            }
            player.getInventory().addItem(new ItemStack[]{new ItemStack(Material.STICK)});
            player.sendMessage("\u00a7aUse o stick para selecionar dois pontos para o jogador " + target.getName() + ".");
            this.tempSelections.put(player.getUniqueId(), new AreaBuilder(target.getUniqueId()));
            return true;
        }
        if (command.getName().equalsIgnoreCase("dlrandom") && args.length == 1 && args[0].equalsIgnoreCase("reload")) {
            this.loadAreas();
            this.reloadConfig();
            sender.sendMessage("\u00a7aAs \u00e1reas foram recarregadas com sucesso.");
            return true;
        }
        return false;
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        Player player = event.getPlayer();
        if (player.isOp()) {
            return;
        }
        Area area = this.playerAreas.get(player.getUniqueId());
        if (area == null || !area.isInside(event.getBlock().getLocation())) {
            event.setCancelled(true);
            player.sendMessage("\u00a7cVoc\u00ea n\u00e3o pode quebrar blocos aqui.");
        }
        this.sendWebhookMessage(player.getName() + " tentou quebrar um bloco fora da \u00e1rea.");
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent event) {
        Player player = event.getPlayer();
        if (player.isOp()) {
            return;
        }
        Area area = this.playerAreas.get(player.getUniqueId());
        if (area == null || !area.isInside(event.getBlock().getLocation())) {
            event.setCancelled(true);
            player.sendMessage("\u00a7cVoc\u00ea n\u00e3o pode colocar blocos aqui.");
        }
        this.sendWebhookMessage(player.getName() + " tentou colocar um bloco fora da \u00e1rea.");
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        if (!player.isOp() || !this.tempSelections.containsKey(player.getUniqueId())) {
            return;
        }
        if (event.getItem() != null && event.getItem().getType() == Material.STICK) {
            Location clickedLocation;
            Location location = clickedLocation = event.getClickedBlock() != null ? event.getClickedBlock().getLocation() : null;
            if (clickedLocation != null) {
                AreaBuilder builder = this.tempSelections.get(player.getUniqueId());
                if (builder.getFirstPoint() == null) {
                    builder.setFirstPoint(clickedLocation);
                    player.sendMessage("\u00a7aPrimeiro ponto definido em: " + this.formatLocation(clickedLocation));
                } else {
                    builder.setSecondPoint(clickedLocation);
                    UUID targetPlayerId = builder.getTargetPlayerId();
                    Area newArea = new Area(builder.getFirstPoint(), builder.getSecondPoint());
                    this.playerAreas.put(targetPlayerId, newArea);
                    this.saveArea(targetPlayerId, newArea);
                    player.sendMessage("\u00a7a\u00c1rea para o jogador foi definida!");
                    this.tempSelections.remove(player.getUniqueId());
                    player.getInventory().remove(Material.STICK);
                }
                event.setCancelled(true);
            }
        }
    }

    private String formatLocation(Location location) {
        return String.format("x: %.0f, y: %.0f, z: %.0f", location.getX(), location.getY(), location.getZ());
    }

    private void sendWebhookMessage(String message) {
        if (this.webhookUrl == null || this.webhookUrl.isEmpty()) {
            return;
        }
        try {
            URL url = new URL(this.webhookUrl);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setDoOutput(true);
            connection.setRequestProperty("Content-Type", "application/json");
            String jsonPayload = "{\"content\": \"" + message + "\"}";
            try (OutputStream os = connection.getOutputStream();){
                byte[] input = jsonPayload.getBytes("utf-8");
                os.write(input, 0, input.length);
            }
            connection.getResponseCode();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void saveArea(UUID playerId, Area area) {
        this.getConfig().set("areas." + String.valueOf(playerId) + ".corner1.x", (Object)area.getCorner1().getX());
        this.getConfig().set("areas." + String.valueOf(playerId) + ".corner1.y", (Object)area.getCorner1().getY());
        this.getConfig().set("areas." + String.valueOf(playerId) + ".corner1.z", (Object)area.getCorner1().getZ());
        this.getConfig().set("areas." + String.valueOf(playerId) + ".corner2.x", (Object)area.getCorner2().getX());
        this.getConfig().set("areas." + String.valueOf(playerId) + ".corner2.y", (Object)area.getCorner2().getY());
        this.getConfig().set("areas." + String.valueOf(playerId) + ".corner2.z", (Object)area.getCorner2().getZ());
        this.saveConfig();
    }

    private void loadAreas() {
        this.playerAreas.clear();
        if (this.getConfig().contains("areas")) {
            for (String playerIdString : this.getConfig().getConfigurationSection("areas").getKeys(false)) {
                UUID playerId = UUID.fromString(playerIdString);
                Location corner1 = new Location(Bukkit.getWorld((String)"world"), this.getConfig().getDouble("areas." + playerIdString + ".corner1.x"), this.getConfig().getDouble("areas." + playerIdString + ".corner1.y"), this.getConfig().getDouble("areas." + playerIdString + ".corner1.z"));
                Location corner2 = new Location(Bukkit.getWorld((String)"world"), this.getConfig().getDouble("areas." + playerIdString + ".corner2.x"), this.getConfig().getDouble("areas." + playerIdString + ".corner2.y"), this.getConfig().getDouble("areas." + playerIdString + ".corner2.z"));
                this.playerAreas.put(playerId, new Area(corner1, corner2));
            }
        }
    }

    private void saveAllAreas() {
        for (UUID playerId : this.playerAreas.keySet()) {
            Area area = this.playerAreas.get(playerId);
            this.saveArea(playerId, area);
        }
    }

    public static class AreaBuilder {
        private final UUID targetPlayerId;
        private Location firstPoint;
        private Location secondPoint;

        public AreaBuilder(UUID targetPlayerId) {
            this.targetPlayerId = targetPlayerId;
        }

        public UUID getTargetPlayerId() {
            return this.targetPlayerId;
        }

        public Location getFirstPoint() {
            return this.firstPoint;
        }

        public void setFirstPoint(Location firstPoint) {
            this.firstPoint = firstPoint;
        }

        public Location getSecondPoint() {
            return this.secondPoint;
        }

        public void setSecondPoint(Location secondPoint) {
            this.secondPoint = secondPoint;
        }
    }

    public static class Area {
        private final Location corner1;
        private final Location corner2;

        public Area(Location corner1, Location corner2) {
            this.corner1 = corner1;
            this.corner2 = corner2;
        }

        public Location getCorner1() {
            return this.corner1;
        }

        public Location getCorner2() {
            return this.corner2;
        }

        public boolean isInside(Location location) {
            double x1 = Math.min(this.corner1.getX(), this.corner2.getX());
            double x2 = Math.max(this.corner1.getX(), this.corner2.getX());
            double y1 = Math.min(this.corner1.getY(), this.corner2.getY());
            double y2 = Math.max(this.corner1.getY(), this.corner2.getY());
            double z1 = Math.min(this.corner1.getZ(), this.corner2.getZ());
            double z2 = Math.max(this.corner1.getZ(), this.corner2.getZ());
            return location.getX() >= x1 && location.getX() <= x2 && location.getY() >= y1 && location.getY() <= y2 && location.getZ() >= z1 && location.getZ() <= z2;
        }
    }
}

