/*
 * Decompiled with CFR 0.152.
 */
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.URL;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class WebhookPlugin
extends JavaPlugin
implements Listener {
    private String joinWebhookUrl;
    private String quitWebhookUrl;

    public void onEnable() {
        this.saveDefaultConfig();
        FileConfiguration config = this.getConfig();
        this.joinWebhookUrl = config.getString("webhook.join");
        this.quitWebhookUrl = config.getString("webhook.quit");
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getLogger().info("WebhookPlugin ativado!");
    }

    public void onDisable() {
        this.getLogger().info("WebhookPlugin desativado!");
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (this.joinWebhookUrl != null && !this.joinWebhookUrl.isEmpty()) {
            String playerName = player.getName();
            String playerIP = this.getPlayerIP(player);
            String playerUUID = player.getUniqueId().toString();
            String embedJson = this.createEmbedJson("Registro de Entrada", playerName, playerIP, playerUUID);
            this.sendToDiscord(this.joinWebhookUrl, embedJson);
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        if (this.quitWebhookUrl != null && !this.quitWebhookUrl.isEmpty()) {
            String playerName = player.getName();
            String playerIP = this.getPlayerIP(player);
            String playerUUID = player.getUniqueId().toString();
            String embedJson = this.createEmbedJson("Registro de Sa\u00edda", playerName, playerIP, playerUUID);
            this.sendToDiscord(this.quitWebhookUrl, embedJson);
        }
    }

    private String getPlayerIP(Player player) {
        InetSocketAddress address = player.getAddress();
        if (address != null) {
            return address.getAddress().getHostAddress();
        }
        return "Desconhecido";
    }

    private String createEmbedJson(String title, String playerName, String playerIP, String playerUUID) {
        return "{\n    \"embeds\": [\n        {\n            \"title\": \"%s\",\n            \"color\": %d,\n            \"fields\": [\n                {\n                    \"name\": \"Nome do Jogador\",\n                    \"value\": \"%s\",\n                    \"inline\": true\n                },\n                {\n                    \"name\": \"IP do Jogador\",\n                    \"value\": \"%s\",\n                    \"inline\": true\n                },\n                {\n                    \"name\": \"UUID do Jogador\",\n                    \"value\": \"%s\",\n                    \"inline\": false\n                }\n            ]\n        }\n    ]\n}\n".formatted(title, title.equals("Registro de Entrada") ? 5763719 : 15548997, playerName, playerIP, playerUUID);
    }

    private void sendToDiscord(String webhookUrl, String embedJson) {
        new Thread(() -> {
            try {
                URL url = new URL(webhookUrl);
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("POST");
                connection.setRequestProperty("Content-Type", "application/json");
                connection.setDoOutput(true);
                try (OutputStream os = connection.getOutputStream();){
                    os.write(embedJson.getBytes());
                    os.flush();
                }
                int responseCode = connection.getResponseCode();
                if (responseCode != 204) {
                    this.getLogger().warning("Erro ao enviar embed para o Discord. C\u00f3digo de resposta: " + responseCode);
                }
            }
            catch (Exception e) {
                this.getLogger().warning("Erro ao enviar embed para o Discord: " + e.getMessage());
            }
        }).start();
    }
}

