/*
 * Decompiled with CFR 0.152.
 */
package DL_Economy;

import DL_Economy.commands.EconomyCommand;
import DL_Economy.commands.TopGUICommand;
import DL_Economy.database.DatabaseManager;
import DL_Economy.holograms.HologramManager;
import DL_Economy.integrations.NPCPluginIntegration;
import DL_Economy.managers.EconomyManager;
import DL_Economy.placeholders.PlaceholderHook;
import DL_Economy.utils.NumberFormatter;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class DL_Economy
extends JavaPlugin
implements Listener {
    private static DL_Economy instance;
    private DatabaseManager databaseManager;
    private EconomyManager economyManager;
    private NumberFormatter formatter;
    private HologramManager hologramManager;

    public void onEnable() {
        instance = this;
        this.saveDefaultConfig();
        this.getLogger().info("\u00a7aIniciando DL_Economy...");
        this.databaseManager = new DatabaseManager(this);
        this.economyManager = new EconomyManager(this);
        this.formatter = new NumberFormatter(this);
        if (this.getServer().getPluginManager().getPlugin("PlaceholderAPI") != null) {
            new PlaceholderHook(this).register();
            this.getLogger().info("\u00a7aPlaceholderAPI detectado! Placeholders carregados.");
        } else {
            this.getLogger().warning("\u00a7ePlaceholderAPI n\u00e3o encontrado. Placeholders desativados.");
        }
        if (this.getServer().getPluginManager().getPlugin("DecentHolograms") != null) {
            this.hologramManager = new HologramManager(this);
            this.getLogger().info("\u00a7aIntegra\u00e7\u00e3o com DecentHolograms ativada!");
        } else {
            this.hologramManager = null;
            this.getLogger().warning("\u00a7eDecentHolograms n\u00e3o encontrado. Hologramas desativados.");
        }
        if (this.getServer().getPluginManager().getPlugin("NpcPlugin-Paper") != null) {
            new NPCPluginIntegration(this);
            this.getLogger().info("\u00a7aIntegra\u00e7\u00e3o com NPC Plugin iniciada!");
        } else {
            this.getLogger().warning("\u00a7eNPC Plugin n\u00e3o encontrado. Integra\u00e7\u00e3o desativada.");
        }
        EconomyCommand economyCommand = new EconomyCommand(this);
        this.getCommand("economy").setExecutor((CommandExecutor)economyCommand);
        this.getCommand("economy").setTabCompleter((TabCompleter)economyCommand);
        this.getCommand("topgui").setExecutor((CommandExecutor)new TopGUICommand(this));
        this.getCommand("topgui").setTabCompleter((TabCompleter)new TopGUICommand(this));
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
        Bukkit.getOnlinePlayers().forEach(p -> this.economyManager.loadPlayer(p.getUniqueId()));
        this.getLogger().info("\u00a7aDL_Economy iniciado com sucesso!");
    }

    public void onDisable() {
        this.getLogger().info("\ud83d\udcbe Salvando todos os saldos...");
        this.economyManager.saveAll();
        this.getLogger().info("\u2705 Todos os saldos foram salvos com sucesso!");
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        this.economyManager.loadPlayer(event.getPlayer().getUniqueId());
        this.getLogger().info("\ud83d\udd39 Dados carregados de " + event.getPlayer().getName());
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        this.economyManager.savePlayer(event.getPlayer().getUniqueId());
        this.getLogger().info("\ud83d\udd38 Dados salvos de " + event.getPlayer().getName());
    }

    public static DL_Economy getInstance() {
        return instance;
    }

    public DatabaseManager getDatabaseManager() {
        return this.databaseManager;
    }

    public EconomyManager getEconomyManager() {
        return this.economyManager;
    }

    public NumberFormatter getFormatter() {
        return this.formatter;
    }

    public HologramManager getHologramManager() {
        return this.hologramManager;
    }

    public void setFormatter(NumberFormatter formatter) {
        this.formatter = formatter;
    }
}

