/*
 * Decompiled with CFR 0.152.
 */
package DL_Economy.commands;

import DL_Economy.DL_Economy;
import DL_Economy.managers.EconomyManager;
import DL_Economy.placeholders.PlaceholderHook;
import DL_Economy.utils.NumberFormatter;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class EconomyCommand
implements CommandExecutor,
TabCompleter {
    private final DL_Economy plugin;
    private final EconomyManager economyManager;

    public EconomyCommand(DL_Economy plugin) {
        this.plugin = plugin;
        this.economyManager = plugin.getEconomyManager();
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (args.length == 0) {
            sender.sendMessage(this.color("&eUso: /economy <add|remove|set|list|top|reload>"));
            return true;
        }
        String action = args[0].toLowerCase();
        List currencies = this.plugin.getConfig().getStringList("currencies");
        if (action.equals("reload")) {
            if (!sender.hasPermission("dleconomy.reload")) {
                sender.sendMessage(this.color("&cVoc\u00ea n\u00e3o tem permiss\u00e3o para usar este comando."));
                return true;
            }
            long start = System.currentTimeMillis();
            this.plugin.reloadConfig();
            this.plugin.setFormatter(new NumberFormatter(this.plugin));
            if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
                new PlaceholderHook(this.plugin).register();
            }
            if (this.plugin.getHologramManager() != null) {
                for (String currency : currencies) {
                    this.plugin.getHologramManager().updateTopHologram(currency);
                }
            }
            long time = System.currentTimeMillis() - start;
            sender.sendMessage(this.color("&aSistema recarregado em &f" + time + "ms!"));
            return true;
        }
        if (args.length < 2 && !action.equals("top")) {
            sender.sendMessage(this.color("&eUso: /economy <add|remove|set|list|top|reload>"));
            return true;
        }
        OfflinePlayer target = args.length > 1 ? Bukkit.getOfflinePlayer((String)args[1]) : null;
        UUID uuid = target != null ? target.getUniqueId() : null;
        switch (action) {
            case "add": 
            case "remove": 
            case "set": {
                if (args.length < 4) {
                    sender.sendMessage(this.color("&cUso correto: /economy " + action + " <player> <tipo> <quantia>"));
                    return true;
                }
                String tipo = args[2].toLowerCase();
                if (!currencies.contains(tipo)) {
                    sender.sendMessage(this.color("&cTipo de money inv\u00e1lido! &7Tipos v\u00e1lidos: &f" + String.join((CharSequence)", ", currencies)));
                    return true;
                }
                double quantia = this.plugin.getFormatter().parse(args[3]);
                if (quantia <= 0.0) {
                    sender.sendMessage(this.color("&cQuantia inv\u00e1lida! Use: 1000, 1.5k, 2m, etc."));
                    return true;
                }
                switch (action) {
                    case "add": {
                        this.economyManager.addBalance(uuid, tipo, quantia);
                        sender.sendMessage(this.color("&aAdicionado &f" + this.plugin.getFormatter().format(quantia) + " " + tipo + " &apara &e" + target.getName()));
                        break;
                    }
                    case "remove": {
                        this.economyManager.removeBalance(uuid, tipo, quantia);
                        sender.sendMessage(this.color("&cRemovido &f" + this.plugin.getFormatter().format(quantia) + " " + tipo + " &dde &e" + target.getName()));
                        break;
                    }
                    case "set": {
                        this.economyManager.setBalance(uuid, tipo, quantia);
                        sender.sendMessage(this.color("&aDefinido &f" + tipo + " &ade &e" + target.getName() + " &apara &f" + this.plugin.getFormatter().format(quantia)));
                    }
                }
                break;
            }
            case "list": {
                if (target == null) {
                    sender.sendMessage(this.color("&cJogador inv\u00e1lido!"));
                    return true;
                }
                sender.sendMessage(this.color("&6------ \ud83d\udcb0 Economia de &e" + target.getName() + " ------"));
                this.economyManager.getAllBalances(uuid).forEach((type, value) -> sender.sendMessage(this.color("&7" + type + ": &a" + this.plugin.getFormatter().format((double)value))));
                break;
            }
            case "top": {
                if (args.length < 2) {
                    sender.sendMessage(this.color("&eUso: /economy top <tipo>"));
                    return true;
                }
                String tipoTop = args[1].toLowerCase();
                if (!currencies.contains(tipoTop)) {
                    sender.sendMessage(this.color("&cTipo inv\u00e1lido! &7Tipos v\u00e1lidos: &f" + String.join((CharSequence)", ", currencies)));
                    return true;
                }
                List<Map.Entry<UUID, Double>> topList = this.economyManager.getTop(tipoTop);
                sender.sendMessage(this.color("&6\ud83c\udfc6 TOP 5 " + tipoTop.toUpperCase()));
                int pos = 1;
                for (Map.Entry<UUID, Double> entry : topList) {
                    OfflinePlayer p = Bukkit.getOfflinePlayer((UUID)entry.getKey());
                    sender.sendMessage(this.color("&7#" + pos + " &a" + p.getName() + " &f- &6" + this.plugin.getFormatter().format(entry.getValue())));
                    ++pos;
                }
                break;
            }
            default: {
                sender.sendMessage(this.color("&cSubcomando inv\u00e1lido! Use: add, remove, set, list, top ou reload."));
            }
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String alias, String[] args) {
        List currencies = this.plugin.getConfig().getStringList("currencies");
        if (args.length == 1) {
            return Arrays.asList("add", "remove", "set", "list", "top", "reload").stream().filter(s -> s.startsWith(args[0].toLowerCase())).collect(Collectors.toList());
        }
        if (args.length == 2 && Arrays.asList("add", "remove", "set", "list").contains(args[0].toLowerCase())) {
            return Bukkit.getOnlinePlayers().stream().map(Player::getName).filter(name -> name.toLowerCase().startsWith(args[1].toLowerCase())).collect(Collectors.toList());
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("top")) {
            return currencies.stream().filter(t -> t.startsWith(args[1].toLowerCase())).collect(Collectors.toList());
        }
        if (args.length == 3 && Arrays.asList("add", "remove", "set").contains(args[0].toLowerCase())) {
            return currencies.stream().filter(t -> t.startsWith(args[2].toLowerCase())).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private String color(String msg) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)msg);
    }
}

