/*
 * Decompiled with CFR 0.152.
 */
package DL_Economy.commands;

import DL_Economy.DL_Economy;
import DL_Economy.managers.EconomyManager;
import DL_Economy.utils.NumberFormatter;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.Plugin;

public class TopGUICommand
implements CommandExecutor,
TabCompleter,
Listener {
    private final DL_Economy plugin;
    private final EconomyManager economyManager;
    private final NumberFormatter formatter;
    private final Map<UUID, Integer> playerPages = new HashMap<UUID, Integer>();
    private final Map<UUID, String> playerCurrencies = new HashMap<UUID, String>();

    public TopGUICommand(DL_Economy plugin) {
        this.plugin = plugin;
        this.economyManager = plugin.getEconomyManager();
        this.formatter = plugin.getFormatter();
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("\u00a7cApenas jogadores podem usar este comando.");
            return true;
        }
        Player player = (Player)sender;
        if (args.length < 1) {
            player.sendMessage("\u00a7eUso: /topgui <tipo>");
            return true;
        }
        String type = args[0].toLowerCase();
        List currencies = this.plugin.getConfig().getStringList("currencies");
        if (!currencies.contains(type)) {
            player.sendMessage("\u00a7cTipo inv\u00e1lido! Tipos v\u00e1lidos: " + String.join((CharSequence)", ", currencies));
            return true;
        }
        this.playerPages.put(player.getUniqueId(), 0);
        this.playerCurrencies.put(player.getUniqueId(), type);
        this.openTopInventory(player, type, 0);
        return true;
    }

    private void openTopInventory(Player player, String currency, int page) {
        List<Map.Entry<UUID, Double>> top = this.economyManager.getTop(currency);
        int totalPlayers = top.size();
        int perPage = 36;
        int totalPages = (int)Math.ceil((double)totalPlayers / (double)perPage);
        page = Math.max(0, Math.min(page, totalPages - 1));
        Inventory inv = Bukkit.createInventory(null, (int)54, (String)("\u00a7eTop " + currency.toUpperCase() + " - P\u00e1gina " + (page + 1)));
        int start = page * perPage;
        int end = Math.min(start + perPage, totalPlayers);
        int slot = 0;
        for (int i = start; i < end; ++i) {
            Map.Entry<UUID, Double> entry = top.get(i);
            OfflinePlayer target = Bukkit.getOfflinePlayer((UUID)entry.getKey());
            double amount = entry.getValue();
            ItemStack skull = new ItemStack(Material.PLAYER_HEAD);
            SkullMeta meta = (SkullMeta)skull.getItemMeta();
            meta.setOwningPlayer(target);
            meta.setDisplayName("\u00a7a#" + (i + 1) + " \u00a7f" + target.getName());
            meta.setLore(Arrays.asList("\u00a77Valor: \u00a76" + this.formatter.format(amount), "\u00a77Posi\u00e7\u00e3o: \u00a7e" + (i + 1)));
            skull.setItemMeta((ItemMeta)meta);
            inv.setItem(slot++, skull);
        }
        if (page > 0) {
            inv.setItem(45, this.createItem(Material.ARROW, "\u00a7a\u2b05 P\u00e1gina anterior"));
        }
        if (page < totalPages - 1) {
            inv.setItem(53, this.createItem(Material.ARROW, "\u00a7aP\u00e1gina seguinte \u27a1"));
        }
        player.openInventory(inv);
    }

    private ItemStack createItem(Material material, String name) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(name);
        item.setItemMeta(meta);
        return item;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent e) {
        List<Map.Entry<UUID, Double>> top;
        int totalPages;
        HumanEntity humanEntity = e.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        if (e.getView().getTitle() == null || !e.getView().getTitle().startsWith("\u00a7eTop")) {
            return;
        }
        e.setCancelled(true);
        int slot = e.getSlot();
        UUID uuid = player.getUniqueId();
        if (!this.playerCurrencies.containsKey(uuid)) {
            return;
        }
        String currency = this.playerCurrencies.get(uuid);
        int page = this.playerPages.getOrDefault(uuid, 0);
        if (slot == 45 && page > 0) {
            this.playerPages.put(uuid, --page);
            this.openTopInventory(player, currency, page);
        } else if (slot == 53 && page < (totalPages = (int)Math.ceil((double)(top = this.economyManager.getTop(currency)).size() / 36.0)) - 1) {
            this.playerPages.put(uuid, ++page);
            this.openTopInventory(player, currency, page);
        }
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String alias, String[] args) {
        if (args.length == 1) {
            return this.plugin.getConfig().getStringList("currencies").stream().filter(c -> c.startsWith(args[0].toLowerCase())).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

