/*
 * Decompiled with CFR 0.152.
 */
package DL_Economy.database;

import DL_Economy.DL_Economy;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class DatabaseManager {
    private final DL_Economy plugin;
    private Connection connection;

    public DatabaseManager(DL_Economy plugin) {
        this.plugin = plugin;
        this.connect();
    }

    private void connect() {
        try {
            String host = this.plugin.getConfig().getString("mysql.host");
            String database = this.plugin.getConfig().getString("mysql.database");
            String user = this.plugin.getConfig().getString("mysql.user");
            String password = this.plugin.getConfig().getString("mysql.password");
            String url = "jdbc:mysql://" + host + "/" + database + "?useSSL=false&autoReconnect=true&allowPublicKeyRetrieval=true";
            this.connection = DriverManager.getConnection(url, user, password);
            this.plugin.getLogger().info("\u2705 Conectado ao MySQL com sucesso!");
            try (Statement stmt = this.connection.createStatement();){
                stmt.executeUpdate("CREATE TABLE IF NOT EXISTS dleconomy_balances (\n    uuid VARCHAR(64) NOT NULL,\n    currency VARCHAR(32) NOT NULL,\n    amount DOUBLE NOT NULL DEFAULT 0,\n    PRIMARY KEY (uuid, currency)\n)\n");
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("\u274c Erro ao conectar ao MySQL: " + e.getMessage());
        }
    }

    public Connection getConnection() {
        return this.connection;
    }

    public Map<String, Double> loadPlayerBalances(UUID uuid) {
        HashMap<String, Double> data = new HashMap<String, Double>();
        try (PreparedStatement ps = this.connection.prepareStatement("SELECT currency, amount FROM dleconomy_balances WHERE uuid = ?");){
            ps.setString(1, uuid.toString());
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                data.put(rs.getString("currency"), rs.getDouble("amount"));
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().warning("Erro ao carregar saldo de " + String.valueOf(uuid) + ": " + e.getMessage());
        }
        return data;
    }

    public void savePlayerBalance(UUID uuid, String currency, double amount) {
        try (PreparedStatement ps = this.connection.prepareStatement("    INSERT INTO dleconomy_balances (uuid, currency, amount)\n    VALUES (?, ?, ?)\n    ON DUPLICATE KEY UPDATE amount = VALUES(amount)\n");){
            ps.setString(1, uuid.toString());
            ps.setString(2, currency);
            ps.setDouble(3, amount);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.getLogger().warning("Erro ao salvar saldo de " + String.valueOf(uuid) + ": " + e.getMessage());
        }
    }

    public void saveAllBalances(Map<UUID, Map<String, Double>> balances) {
        balances.forEach((uuid, data) -> data.forEach((currency, value) -> this.savePlayerBalance((UUID)uuid, (String)currency, (double)value)));
    }

    public Map<UUID, Map<String, Double>> loadAllBalances() {
        HashMap<UUID, Map<String, Double>> allData = new HashMap<UUID, Map<String, Double>>();
        try (PreparedStatement ps = this.connection.prepareStatement("SELECT uuid, currency, amount FROM dleconomy_balances");){
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                UUID uuid = UUID.fromString(rs.getString("uuid"));
                String currency = rs.getString("currency");
                double amount = rs.getDouble("amount");
                allData.computeIfAbsent(uuid, k -> new HashMap()).put(currency, amount);
            }
            this.plugin.getLogger().info("\ud83d\udcbe " + allData.size() + " jogadores carregados do banco para cache global.");
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("\u274c Erro ao carregar todos os saldos do banco: " + e.getMessage());
        }
        return allData;
    }
}

