/*
 * Decompiled with CFR 0.152.
 */
package DL_Economy.holograms;

import DL_Economy.DL_Economy;
import eu.decentsoftware.holograms.api.DHAPI;
import eu.decentsoftware.holograms.api.holograms.Hologram;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;

public class HologramManager {
    private final DL_Economy plugin;
    private final Map<String, Hologram> holograms = new HashMap<String, Hologram>();
    private final double baseX = 0.5;
    private final double baseY = 70.0;
    private final double baseZ = 0.5;
    private final double offsetX = 5.0;

    public HologramManager(DL_Economy plugin) {
        this.plugin = plugin;
        Bukkit.getScheduler().runTaskLater((Plugin)plugin, () -> {
            this.loadOrCreateAll();
            Bukkit.getScheduler().runTaskLater((Plugin)plugin, this::forceUpdateAllHolograms, 200L);
            long intervalMinutes = plugin.getConfig().getLong("holograms.update-interval-minutes", 5L);
            long ticks = 1200L * intervalMinutes;
            plugin.getLogger().info("\u23f1 Atualiza\u00e7\u00e3o autom\u00e1tica dos hologramas configurada para a cada " + intervalMinutes + " minuto(s).");
            Bukkit.getScheduler().runTaskTimer((Plugin)plugin, this::updateHolograms, ticks, ticks);
        }, 100L);
    }

    private void loadOrCreateAll() {
        List currencies = this.plugin.getConfig().getStringList("currencies");
        if (currencies == null || currencies.isEmpty()) {
            this.plugin.getLogger().warning("Nenhuma currency encontrada no config.yml em 'currencies'. Hologramas n\u00e3o ser\u00e3o criados.");
            return;
        }
        int idx = 0;
        for (String currency : currencies) {
            String key = currency.toLowerCase(Locale.ROOT).trim();
            Location loc = this.readLocationFromConfig(key, idx);
            String holoId = "top_" + key;
            Hologram hologram = DHAPI.getHologram((String)holoId);
            if (hologram == null) {
                hologram = DHAPI.createHologram((String)holoId, (Location)loc, (boolean)false, Collections.singletonList("\u00a7eCarregando..."));
                try {
                    hologram.setDisplayRange(100);
                    hologram.setUpdateRange(100);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                hologram.save();
            }
            this.holograms.put(key, hologram);
            ++idx;
        }
    }

    private Location readLocationFromConfig(String currency, int indexFallback) {
        String basePath = "holograms." + currency;
        if (this.plugin.getConfig().contains(basePath + ".world")) {
            String worldName = this.plugin.getConfig().getString(basePath + ".world", "world");
            World w = Bukkit.getWorld((String)worldName);
            double x = this.plugin.getConfig().getDouble(basePath + ".x", 0.5 + (double)indexFallback * 5.0);
            double y = this.plugin.getConfig().getDouble(basePath + ".y", 70.0);
            double z = this.plugin.getConfig().getDouble(basePath + ".z", 0.5);
            if (w == null) {
                w = (World)Bukkit.getWorlds().get(0);
            }
            return new Location(w, x, y, z);
        }
        World w = (World)Bukkit.getWorlds().get(0);
        return new Location(w, 0.5 + (double)indexFallback * 5.0, 70.0, 0.5);
    }

    public void forceUpdateAllHolograms() {
        this.plugin.getLogger().info("\ud83e\ude84 Atualizando hologramas de TOPs automaticamente ao iniciar o servidor...");
        try {
            List currencies = this.plugin.getConfig().getStringList("currencies");
            if (currencies == null || currencies.isEmpty()) {
                return;
            }
            this.plugin.getEconomyManager().loadAllPlayersFromDatabase();
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                for (String currency : currencies) {
                    this.updateTopHologram(currency.toLowerCase(Locale.ROOT).trim());
                }
                this.plugin.getLogger().info("\u2705 Hologramas de TOPs atualizados com sucesso no startup.");
            }, 200L);
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Erro ao atualizar hologramas iniciais: " + e.getMessage());
        }
    }

    public void updateHolograms() {
        try {
            List currencies = this.plugin.getConfig().getStringList("currencies");
            if (currencies == null || currencies.isEmpty()) {
                return;
            }
            for (String currency : currencies) {
                this.updateTopHologram(currency.toLowerCase(Locale.ROOT).trim());
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Erro ao atualizar hologramas: " + e.getMessage());
        }
    }

    public void updateTopHologram(String type) {
        Hologram hologram;
        if (!this.holograms.containsKey(type)) {
            this.loadOrCreateAll();
        }
        if ((hologram = this.holograms.get(type)) == null) {
            return;
        }
        List<Map.Entry<UUID, Double>> topList = this.plugin.getEconomyManager().getTop(type);
        ArrayList<CallSite> lines = new ArrayList<CallSite>();
        lines.add((CallSite)((Object)("\u00a7e\u00a7l\ud83c\udfc6 TOP 5 " + type.toUpperCase(Locale.ROOT) + " \ud83c\udfc6")));
        int i = 1;
        for (Map.Entry<UUID, Double> entry : topList) {
            OfflinePlayer player = Bukkit.getOfflinePlayer((UUID)entry.getKey());
            String name = player != null && player.getName() != null ? player.getName() : "Desconhecido";
            String formatted = this.plugin.getFormatter().format(entry.getValue());
            lines.add((CallSite)((Object)("\u00a77" + i + ". \u00a7a" + name + " \u00a7f- \u00a76" + formatted)));
            if (++i <= 5) continue;
            break;
        }
        while (i <= 5) {
            lines.add((CallSite)((Object)("\u00a77" + i + ". \u00a7f---")));
            ++i;
        }
        try {
            DHAPI.setHologramLines((Hologram)hologram, lines);
            hologram.save();
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Falha ao atualizar holograma '" + type + "': " + e.getMessage());
        }
    }
}

