/*
 * Decompiled with CFR 0.152.
 */
package DL_Economy.integrations;

import DL_Economy.DL_Economy;
import DL_Economy.managers.EconomyManager;
import de.eisi05.npc.api.manager.NpcManager;
import de.eisi05.npc.api.objects.NPC;
import de.eisi05.npc.api.objects.NpcName;
import de.eisi05.npc.api.objects.NpcOption;
import de.eisi05.npc.api.objects.NpcSkin;
import de.eisi05.npc.api.objects.Skin;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class NPCPluginIntegration {
    private final DL_Economy plugin;
    private final EconomyManager economyManager;

    public NPCPluginIntegration(DL_Economy plugin) {
        this.plugin = plugin;
        this.economyManager = plugin.getEconomyManager();
        try {
            Class.forName("de.eisi05.npc.api.NpcApi");
        }
        catch (Exception e) {
            plugin.getLogger().warning("\u26a0 NPC Plugin (de.eisi05.npc.api) n\u00e3o encontrado. Integra\u00e7\u00e3o desativada.");
            return;
        }
        plugin.getLogger().info("\u2705 Integra\u00e7\u00e3o com NPC Plugin ativada!");
        this.startAutoUpdater();
    }

    private void startAutoUpdater() {
        int interval = this.plugin.getConfig().getInt("npc-update-interval", 60);
        new BukkitRunnable(){

            public void run() {
                NPCPluginIntegration.this.updateTopNPCs();
            }
        }.runTaskTimer((Plugin)this.plugin, 200L, 20L * (long)interval);
    }

    public void updateTopNPCs() {
        List currencies = this.plugin.getConfig().getStringList("currencies");
        List npcs = NpcManager.getList();
        for (String currency : currencies) {
            String targetName = "top" + currency.toLowerCase();
            for (NPC npc : npcs) {
                String npcPlainName = PlainTextComponentSerializer.plainText().serialize(npc.getName());
                if (!npcPlainName.equalsIgnoreCase(targetName)) continue;
                this.updateTopForNPC(npc, currency);
            }
        }
    }

    private void updateTopForNPC(NPC npc, String currency) {
        List<Map.Entry<UUID, Double>> topList = this.economyManager.getTop(currency);
        if (topList.isEmpty()) {
            npc.setName(NpcName.of((Component)Component.text((String)("\u00a7cSem top 1 de " + currency))));
            return;
        }
        Map.Entry<UUID, Double> top1 = topList.get(0);
        OfflinePlayer topPlayer = Bukkit.getOfflinePlayer((UUID)top1.getKey());
        String formatted = this.plugin.getFormatter().format(top1.getValue());
        TextComponent displayName = Component.text((String)("\u00a7e\u00a7lTOP 1 " + currency.toUpperCase() + "\n\u00a7a" + topPlayer.getName() + " \u00a77- \u00a76" + formatted));
        npc.setName(NpcName.of((Component)displayName));
        Optional skinOpt = Skin.fetchSkin((String)topPlayer.getName());
        skinOpt.ifPresent(skin -> npc.setOption(NpcOption.SKIN, (Object)NpcSkin.of((Skin)skin)));
        npc.showNpcToAllPlayers();
        this.plugin.getLogger().info("\ud83d\udc51 NPC '" + PlainTextComponentSerializer.plainText().serialize(npc.getName()) + "' atualizado para " + topPlayer.getName() + " no ranking de " + currency);
    }
}

