/*
 * Decompiled with CFR 0.152.
 */
package DL_Economy.managers;

import DL_Economy.DL_Economy;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;

public class EconomyManager {
    private final Map<UUID, Map<String, Double>> balances = new HashMap<UUID, Map<String, Double>>();
    private final DL_Economy plugin;

    public EconomyManager(DL_Economy plugin) {
        this.plugin = plugin;
    }

    public void loadPlayer(UUID uuid) {
        Map<String, Double> data = this.plugin.getDatabaseManager().loadPlayerBalances(uuid);
        this.balances.put(uuid, new HashMap<String, Double>(data));
    }

    public void savePlayer(UUID uuid) {
        if (this.balances.containsKey(uuid)) {
            Map<String, Double> data = this.balances.get(uuid);
            data.forEach((currency, value) -> this.plugin.getDatabaseManager().savePlayerBalance(uuid, (String)currency, (double)value));
        }
    }

    public void saveAll() {
        this.plugin.getDatabaseManager().saveAllBalances(this.balances);
    }

    public double getBalance(UUID uuid, String currency) {
        return ((Map)this.balances.getOrDefault(uuid, new HashMap())).getOrDefault(currency, 0.0);
    }

    public void setBalance(UUID uuid, String currency, double amount) {
        this.balances.computeIfAbsent(uuid, k -> new HashMap()).put(currency, amount);
        this.plugin.getDatabaseManager().savePlayerBalance(uuid, currency, amount);
        this.plugin.getHologramManager().updateTopHologram(currency);
    }

    public void addBalance(UUID uuid, String currency, double amount) {
        this.setBalance(uuid, currency, this.getBalance(uuid, currency) + amount);
    }

    public void removeBalance(UUID uuid, String currency, double amount) {
        this.setBalance(uuid, currency, Math.max(0.0, this.getBalance(uuid, currency) - amount));
    }

    public void loadAllPlayersFromDatabase() {
        Map<UUID, Map<String, Double>> allBalances = this.plugin.getDatabaseManager().loadAllBalances();
        if (allBalances != null && !allBalances.isEmpty()) {
            this.balances.clear();
            this.balances.putAll(allBalances);
            this.plugin.getLogger().info("\ud83d\udcbe Dados de economia carregados: " + this.balances.size() + " jogadores encontrados.");
        } else {
            this.plugin.getLogger().warning("\u26a0 Nenhum dado de economia encontrado no banco de dados!");
        }
    }

    public Map<String, Double> getAllBalances(UUID uuid) {
        return this.balances.getOrDefault(uuid, new HashMap());
    }

    public List<Map.Entry<UUID, Double>> getTop(String currency) {
        return this.balances.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((Map)e.getValue()).getOrDefault(currency, 0.0))).entrySet().stream().sorted((a, b) -> Double.compare((Double)b.getValue(), (Double)a.getValue())).limit(5L).toList();
    }
}

