/*
 * Decompiled with CFR 0.152.
 */
package DL_Economy.placeholders;

import DL_Economy.DL_Economy;
import DL_Economy.managers.EconomyManager;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;

public class PlaceholderHook
extends PlaceholderExpansion {
    private final DL_Economy plugin;
    private final EconomyManager economyManager;
    private final List<String> currencies;

    public PlaceholderHook(DL_Economy plugin) {
        this.plugin = plugin;
        this.economyManager = plugin.getEconomyManager();
        this.currencies = plugin.getConfig().getStringList("currencies");
    }

    @NotNull
    public String getIdentifier() {
        return "dleconomy";
    }

    @NotNull
    public String getAuthor() {
        return "DL_Scripts";
    }

    @NotNull
    public String getVersion() {
        return "1.0.0";
    }

    public String onRequest(OfflinePlayer player, @NotNull String params) {
        if (player == null) {
            return "";
        }
        if (this.currencies.contains(params.toLowerCase())) {
            double value = this.economyManager.getBalance(player.getUniqueId(), params.toLowerCase());
            return this.plugin.getFormatter().format(value);
        }
        if (params.startsWith("top_")) {
            int position;
            String[] split = params.split("_");
            if (split.length < 4) {
                return null;
            }
            try {
                position = Integer.parseInt(split[1]);
            }
            catch (NumberFormatException e) {
                return null;
            }
            String type = split[2].toLowerCase();
            String dataType = split[3].toLowerCase();
            if (!this.currencies.contains(type)) {
                return "Tipo inv\u00e1lido";
            }
            List<Map.Entry<UUID, Double>> topList = this.economyManager.getTop(type);
            if (topList.size() < position) {
                return "-";
            }
            Map.Entry<UUID, Double> entry = topList.get(position - 1);
            OfflinePlayer topPlayer = Bukkit.getOfflinePlayer((UUID)entry.getKey());
            if (dataType.equals("name")) {
                return topPlayer != null && topPlayer.getName() != null ? topPlayer.getName() : "Desconhecido";
            }
            if (dataType.equals("value")) {
                return this.plugin.getFormatter().format(entry.getValue());
            }
        }
        return null;
    }
}

