/*
 * Decompiled with CFR 0.152.
 */
package DL_Economy.utils;

import DL_Economy.DL_Economy;
import java.text.DecimalFormat;
import java.util.List;

public class NumberFormatter {
    private final boolean useSuffix;
    private final double minValue;
    private final List<String> suffixes;

    public NumberFormatter(DL_Economy plugin) {
        this.useSuffix = plugin.getConfig().getBoolean("format.use", true);
        this.minValue = plugin.getConfig().getDouble("format.minValue", 1000.0);
        this.suffixes = plugin.getConfig().getStringList("format.suffixes");
    }

    public String format(double value) {
        int index;
        if (!this.useSuffix || value < this.minValue) {
            return new DecimalFormat("#,##0.##").format(value);
        }
        for (index = 0; value >= 1000.0 && index < this.suffixes.size() - 1; value /= 1000.0, ++index) {
        }
        return new DecimalFormat("#,##0.##").format(value) + this.suffixes.get(index);
    }

    public double parse(String input) {
        if (input == null || input.isEmpty()) {
            return 0.0;
        }
        input = input.trim().toUpperCase().replace(",", ".");
        double multiplier = 1.0;
        if (input.endsWith("K")) {
            multiplier = 1000.0;
        } else if (input.endsWith("M")) {
            multiplier = 1000000.0;
        } else if (input.endsWith("B")) {
            multiplier = 1.0E9;
        } else if (input.endsWith("T")) {
            multiplier = 1.0E12;
        }
        input = input.replaceAll("[^0-9.]", "");
        try {
            return Double.parseDouble(input) * multiplier;
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
    }
}

