/*
 * Decompiled with CFR 0.152.
 */
package DL_Mina;

import DL_Economy.DL_Economy;
import DL_Economy.utils.NumberFormatter;
import DL_Mina.commands.FlyCommand;
import DL_Mina.commands.MinaCommand;
import DL_Mina.commands.MinaUpgradeCommand;
import DL_Mina.commands.SpawnCommand;
import DL_Mina.commands.VerificarCommand;
import DL_Mina.listeners.BlockMineListener;
import DL_Mina.listeners.PlayerJoinListener;
import DL_Mina.listeners.PlayerQuitListener;
import DL_Mina.listeners.UpgradeNPCListener;
import DL_Mina.managers.AntiMacroManager;
import DL_Mina.managers.CacheManager;
import DL_Mina.managers.LevelManager;
import DL_Mina.managers.MinaManager;
import DL_Mina.managers.MineDataManager;
import DL_Mina.managers.MultiplierManager;
import DL_Mina.managers.RewardManager;
import DL_Mina.placeholders.MinaPlaceholders;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class DL_Mina
extends JavaPlugin {
    private static DL_Mina instance;
    private MinaManager minaManager;
    private LevelManager levelManager;
    private MultiplierManager multiplierManager;
    private RewardManager rewardManager;
    private CacheManager cacheManager;
    private MineDataManager mineDataManager;
    private AntiMacroManager antiMacroManager;
    private NumberFormatter economyFormatter;

    public void onLoad() {
        instance = this;
    }

    public void onEnable() {
        this.saveDefaultConfig();
        this.getLogger().info("\u00a7aAtivando DL_Mina PRO...");
        DL_Economy economyPlugin = (DL_Economy)Bukkit.getPluginManager().getPlugin("DL_Economy");
        if (economyPlugin != null && economyPlugin.isEnabled()) {
            this.economyFormatter = economyPlugin.getFormatter();
            this.getLogger().info("\u00a7aDL_Economy detectado \u2014 integra\u00e7\u00e3o de formatador ativa!");
        } else {
            this.getLogger().warning("\u00a7cDL_Economy n\u00e3o encontrado! Formatador desativado.");
        }
        this.mineDataManager = new MineDataManager(this);
        this.cacheManager = new CacheManager();
        this.levelManager = new LevelManager(this);
        this.multiplierManager = new MultiplierManager(this);
        this.rewardManager = new RewardManager(this);
        this.minaManager = new MinaManager(this);
        this.antiMacroManager = new AntiMacroManager(this);
        this.getCommand("mina").setExecutor((CommandExecutor)new MinaCommand(this));
        this.getCommand("spawn").setExecutor((CommandExecutor)new SpawnCommand(this));
        this.getCommand("fly").setExecutor((CommandExecutor)new FlyCommand(this));
        this.getCommand("verificar").setExecutor((CommandExecutor)new VerificarCommand(this));
        this.getCommand("minaupgrade").setExecutor((CommandExecutor)new MinaUpgradeCommand(this));
        Bukkit.getPluginManager().registerEvents((Listener)new PlayerJoinListener(this), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new PlayerQuitListener(this), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new BlockMineListener(this), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new UpgradeNPCListener(this), (Plugin)this);
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            new MinaPlaceholders(this).register();
            this.getLogger().info("\u00a7aPlaceholderAPI detectado e integrado!");
        }
        Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this, () -> {
            try {
                this.mineDataManager.saveAll();
                this.getLogger().info("\u00a7e[AutoSave] Minas salvas automaticamente.");
            }
            catch (Exception e) {
                this.getLogger().warning("Falha ao salvar minas automaticamente: " + e.getMessage());
            }
        }, 6000L, 6000L);
        this.getLogger().info("\u00a7aDL_Mina PRO iniciado com sucesso!");
    }

    public void onDisable() {
        this.getLogger().warning("\u00a7eSalvando dados antes de desligar...");
        if (this.mineDataManager != null) {
            this.mineDataManager.saveAll();
        }
        this.getLogger().severe("\u00a7cDL_Mina PRO desligado.");
    }

    public static DL_Mina getInstance() {
        return instance;
    }

    public MinaManager getMinaManager() {
        return this.minaManager;
    }

    public LevelManager getLevelManager() {
        return this.levelManager;
    }

    public MultiplierManager getMultiplierManager() {
        return this.multiplierManager;
    }

    public RewardManager getRewardManager() {
        return this.rewardManager;
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    public MineDataManager getMineDataManager() {
        return this.mineDataManager;
    }

    public AntiMacroManager getAntiMacroManager() {
        return this.antiMacroManager;
    }

    public NumberFormatter getEconomyFormatter() {
        return this.economyFormatter;
    }
}

