/*
 * Decompiled with CFR 0.152.
 */
package DL_Mina.commands;

import DL_Mina.DL_Mina;
import DL_Mina.objects.PlayerMine;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class MinaUpgradeCommand
implements CommandExecutor {
    private final DL_Mina plugin;

    public MinaUpgradeCommand(DL_Mina plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        int nivel;
        if (!sender.hasPermission("dlmina.admin")) {
            sender.sendMessage("\u00a7cVoc\u00ea n\u00e3o tem permiss\u00e3o para usar este comando.");
            return true;
        }
        if (args.length != 3) {
            sender.sendMessage("\u00a7eUso correto: \u00a7f/mina upgrade <mina|blocos> <player> <n\u00edvel>");
            return true;
        }
        String tipo = args[0].toLowerCase();
        String nome = args[1];
        try {
            nivel = Integer.parseInt(args[2]);
        }
        catch (NumberFormatException e) {
            sender.sendMessage("\u00a7cO n\u00edvel precisa ser um n\u00famero v\u00e1lido.");
            return true;
        }
        Player alvo = Bukkit.getPlayerExact((String)nome);
        UUID uuid = null;
        if (alvo != null) {
            uuid = alvo.getUniqueId();
        } else {
            try {
                uuid = UUID.nameUUIDFromBytes(("OfflinePlayer:" + nome).getBytes());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (uuid == null) {
            sender.sendMessage("\u00a7cJogador n\u00e3o encontrado: \u00a7f" + nome);
            return true;
        }
        PlayerMine mine = this.plugin.getMineDataManager().getMine(uuid);
        if (mine == null) {
            sender.sendMessage("\u00a7cO jogador \u00a7f" + nome + " \u00a7cn\u00e3o possui mina registrada.");
            return true;
        }
        switch (tipo) {
            case "mina": {
                mine.setLevel(nivel);
                this.plugin.getMineDataManager().saveMine(mine);
                sender.sendMessage("\u00a7a\u2714 N\u00edvel da mina de \u00a7e" + nome + " \u00a7asetado para \u00a7b" + nivel);
                if (alvo == null) break;
                alvo.sendMessage("\u00a7b\u2692 Seu n\u00edvel da mina foi ajustado para \u00a7e" + nivel + "\u00a7b por um administrador.");
                break;
            }
            case "blocos": {
                mine.setBlockLevel(nivel);
                this.plugin.getMineDataManager().saveMine(mine);
                sender.sendMessage("\u00a7a\u2714 N\u00edvel dos blocos de \u00a7e" + nome + " \u00a7asetado para \u00a7b" + nivel);
                if (alvo == null) break;
                alvo.sendMessage("\u00a7b\ud83e\uddf1 Seu n\u00edvel dos blocos foi ajustado para \u00a7e" + nivel + "\u00a7b por um administrador.");
                break;
            }
            default: {
                sender.sendMessage("\u00a7cTipo inv\u00e1lido! Use \u00a7fmina\u00a7c ou \u00a7fblocos\u00a7c.");
            }
        }
        return true;
    }
}

