/*
 * Decompiled with CFR 0.152.
 */
package DL_Mina.listeners;

import DL_Mina.DL_Mina;
import DL_Mina.objects.PlayerMine;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class BlockMineListener
implements Listener {
    private final DL_Mina plugin;
    private final Set<String> brokenBlocks = new HashSet<String>();
    private final Map<String, Material> brokenTypes = new HashMap<String, Material>();

    public BlockMineListener(DL_Mina plugin) {
        this.plugin = plugin;
        this.startMineRegenerationTask();
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent e) {
        boolean dentroDaMina;
        Player player = e.getPlayer();
        this.plugin.getAntiMacroManager().handleBlockBreak(player);
        if (player.getGameMode().toString().equalsIgnoreCase("CREATIVE")) {
            return;
        }
        if (!player.getWorld().getName().equalsIgnoreCase("mina_test")) {
            return;
        }
        int x = e.getBlock().getX();
        int y = e.getBlock().getY();
        int z = e.getBlock().getZ();
        boolean bl = dentroDaMina = x >= -24 && x <= 40 && y >= -52 && y <= -24 && z >= -17 && z <= 35;
        if (!dentroDaMina) {
            e.setCancelled(true);
            player.sendMessage("\u00a7cVoc\u00ea n\u00e3o pode quebrar fora da \u00e1rea da mina!");
            return;
        }
        e.setDropItems(false);
        e.setExpToDrop(0);
        PlayerMine mine = this.plugin.getMineDataManager().getMine(player.getUniqueId());
        if (mine == null) {
            return;
        }
        String blockName = this.plugin.getConfig().getString("blocks-upgrade.levels." + mine.getBlockLevel(), "STONE");
        Material blockType = Material.matchMaterial((String)blockName);
        if (blockType == null) {
            blockType = Material.STONE;
        }
        if (e.getBlock().getType() == blockType) {
            this.plugin.getMinaManager().handleMine(player);
            String key = x + "," + y + "," + z;
            this.brokenBlocks.add(key);
            this.brokenTypes.put(key, blockType);
            if (this.plugin.getConfig().getBoolean("money.play-particles", true)) {
                player.spawnParticle(Particle.HAPPY_VILLAGER, e.getBlock().getLocation().add(0.5, 1.0, 0.5), 8, 0.3, 0.3, 0.3, 0.01);
                player.spawnParticle(Particle.CRIT, e.getBlock().getLocation().add(0.5, 0.8, 0.5), 5, 0.2, 0.2, 0.2, 0.02);
            }
        }
    }

    private void startMineRegenerationTask() {
        new BukkitRunnable(){

            public void run() {
                if (BlockMineListener.this.brokenBlocks.isEmpty()) {
                    return;
                }
                int regenerated = 0;
                for (String key : BlockMineListener.this.brokenBlocks) {
                    String[] split = key.split(",");
                    int x = Integer.parseInt(split[0]);
                    int y = Integer.parseInt(split[1]);
                    int z = Integer.parseInt(split[2]);
                    Material tipo = BlockMineListener.this.brokenTypes.getOrDefault(key, Material.PRISMARINE_BRICKS);
                    Bukkit.getScheduler().runTask((Plugin)BlockMineListener.this.plugin, () -> {
                        if (BlockMineListener.this.plugin.getServer().getWorld("mina_test") != null) {
                            BlockMineListener.this.plugin.getServer().getWorld("mina_test").getBlockAt(x, y, z).setType(tipo, false);
                        }
                    });
                    ++regenerated;
                }
                BlockMineListener.this.brokenBlocks.clear();
                BlockMineListener.this.brokenTypes.clear();
                Bukkit.getLogger().info("\u267b\ufe0f Mina regenerada automaticamente: " + regenerated + " blocos restaurados!");
            }
        }.runTaskTimerAsynchronously((Plugin)this.plugin, 6000L, 6000L);
    }

    @EventHandler
    public void onEntityDamage(EntityDamageEvent e) {
        if (!(e.getEntity() instanceof Player)) {
            return;
        }
        if (e.getCause() == EntityDamageEvent.DamageCause.FALL || e.getCause() == EntityDamageEvent.DamageCause.SUFFOCATION) {
            e.setCancelled(true);
        }
    }
}

