/*
 * Decompiled with CFR 0.152.
 */
package DL_Mina.listeners;

import DL_Mina.DL_Mina;
import DL_Mina.managers.MinaManager;
import DL_Mina.objects.PlayerMine;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;

public class PlayerQuitListener
implements Listener {
    private final DL_Mina plugin;
    private final MinaManager minaManager;

    public PlayerQuitListener(DL_Mina plugin) {
        this.plugin = plugin;
        this.minaManager = plugin.getMinaManager();
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent e) {
        Player player = e.getPlayer();
        String worldName = player.getWorld().getName();
        if (worldName.startsWith("mina_") || worldName.equalsIgnoreCase("mina_test")) {
            PlayerMine mine = this.plugin.getMineDataManager().getMine(player.getUniqueId());
            if (mine != null) {
                this.plugin.getMineDataManager().saveMine(mine);
            }
            for (ItemStack item : player.getInventory().getContents()) {
                String name;
                if (item == null || !item.hasItemMeta() || !item.getItemMeta().hasDisplayName() || !(name = item.getItemMeta().getDisplayName()).contains("\u00a76\u00a7lPicareta Suprema")) continue;
                player.getInventory().remove(item);
            }
            this.minaManager.getInventoryManager().saveInventory(player);
            this.minaManager.getInventoryManager().restoreInventory(player);
            String w = this.plugin.getConfig().getString("spawn-location.world", "world");
            double x = this.plugin.getConfig().getDouble("spawn-location.x", 0.0);
            double y = this.plugin.getConfig().getDouble("spawn-location.y", 80.0);
            double z = this.plugin.getConfig().getDouble("spawn-location.z", 0.0);
            float yaw = (float)this.plugin.getConfig().getDouble("spawn-location.yaw", 0.0);
            float pitch = (float)this.plugin.getConfig().getDouble("spawn-location.pitch", 0.0);
            Location spawn = new Location(Bukkit.getWorld((String)w), x, y, z, yaw, pitch);
            player.teleport(spawn);
            player.setAllowFlight(false);
            player.setFlying(false);
            player.sendMessage("\u00a7eVoc\u00ea saiu da sua mina \u2014 invent\u00e1rio restaurado e progresso salvo!");
        }
    }
}

