/*
 * Decompiled with CFR 0.152.
 */
package DL_Mina.managers;

import DL_Mina.DL_Mina;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class AntiMacroManager {
    private final DL_Mina plugin;
    private final Map<UUID, Long> lastBreak = new HashMap<UUID, Long>();
    private final Map<UUID, Integer> blockCount = new HashMap<UUID, Integer>();
    private final Map<UUID, Integer> suspiciousHits = new HashMap<UUID, Integer>();
    private final Map<UUID, String> activeChallenges = new HashMap<UUID, String>();
    private final Random random = new Random();
    private final int windowSize;
    private final int suspiciousThreshold;
    private final long expectedSpeed;
    private final int responseTime;
    private final String onFail;
    private final String failCommand;

    public AntiMacroManager(DL_Mina plugin) {
        this.plugin = plugin;
        this.windowSize = plugin.getConfig().getInt("anti-macro.check-every-blocks", 150);
        this.suspiciousThreshold = plugin.getConfig().getInt("anti-macro.suspicious-threshold", 3);
        this.expectedSpeed = plugin.getConfig().getLong("anti-macro.expected-speed-ms", 40L);
        this.responseTime = plugin.getConfig().getInt("anti-macro.max-response-time", 10);
        this.onFail = plugin.getConfig().getString("anti-macro.on-fail", "kick");
        this.failCommand = plugin.getConfig().getString("anti-macro.fail-command", "kick %player% Macro detectado!");
    }

    public void handleBlockBreak(Player player) {
        if (!this.plugin.getConfig().getBoolean("anti-macro.enabled", true)) {
            return;
        }
        if (!player.getWorld().getName().equalsIgnoreCase("mina_test")) {
            return;
        }
        UUID uuid = player.getUniqueId();
        long now = System.currentTimeMillis();
        long last = this.lastBreak.getOrDefault(uuid, now);
        long diff = now - last;
        this.lastBreak.put(uuid, now);
        int count = this.blockCount.getOrDefault(uuid, 0) + 1;
        this.blockCount.put(uuid, count);
        if (diff < this.expectedSpeed) {
            int suspicious = this.suspiciousHits.getOrDefault(uuid, 0) + 1;
            this.suspiciousHits.put(uuid, suspicious);
            if (suspicious >= this.suspiciousThreshold && !this.activeChallenges.containsKey(uuid)) {
                this.triggerChallenge(player);
                this.suspiciousHits.put(uuid, 0);
            }
        }
        if (count >= this.windowSize) {
            this.blockCount.put(uuid, 0);
            this.suspiciousHits.put(uuid, 0);
        }
    }

    private void triggerChallenge(Player player) {
        UUID uuid = player.getUniqueId();
        String code = this.generateCode();
        this.activeChallenges.put(uuid, code);
        player.sendTitle("\u00a7e\u26a0\ufe0f Verifica\u00e7\u00e3o Anti-Macro", "\u00a77Digite \u00a7a/verificar " + code + " \u00a77em at\u00e9 \u00a7c" + this.responseTime + "s", 10, 100, 10);
        player.sendMessage("\u00a7e[ANTI-MACRO] \u00a77Digite \u00a7a/verificar " + code + " \u00a77para confirmar que est\u00e1 jogando.");
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            if (this.activeChallenges.containsKey(uuid)) {
                this.fail(player);
            }
        }, (long)this.responseTime * 20L);
    }

    public void verify(Player player, String input) {
        UUID uuid = player.getUniqueId();
        if (!this.activeChallenges.containsKey(uuid)) {
            player.sendMessage("\u00a7eVoc\u00ea n\u00e3o possui nenhuma verifica\u00e7\u00e3o ativa.");
            return;
        }
        String code = this.activeChallenges.get(uuid);
        if (code.equalsIgnoreCase(input)) {
            player.sendMessage("\u00a7a\u2705 Verifica\u00e7\u00e3o conclu\u00edda com sucesso!");
            this.activeChallenges.remove(uuid);
        } else {
            this.fail(player);
        }
    }

    private void fail(Player player) {
        UUID uuid = player.getUniqueId();
        this.activeChallenges.remove(uuid);
        this.suspiciousHits.put(uuid, 0);
        this.blockCount.put(uuid, 0);
        String failMsg = this.plugin.getConfig().getString("anti-macro.fail-message", "\u00a7c\u274c Voc\u00ea falhou no teste anti-macro!");
        player.sendMessage(failMsg);
        switch (this.onFail.toLowerCase()) {
            case "kick": {
                player.kickPlayer("\u00a7cMacro detectado!");
                break;
            }
            case "command": {
                Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)this.failCommand.replace("%player%", player.getName()));
                break;
            }
            case "alert": {
                Bukkit.broadcastMessage((String)("\u00a7c\u26a0 O jogador \u00a7e" + player.getName() + " \u00a7cfoi detectado usando macro!"));
            }
        }
    }

    private String generateCode() {
        String chars = "ABCDEFGHJKLMNPQRSTUVWXYZ123456789";
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 4; ++i) {
            sb.append(chars.charAt(this.random.nextInt(chars.length())));
        }
        return sb.toString();
    }
}

