/*
 * Decompiled with CFR 0.152.
 */
package DL_Mina.managers;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class CacheManager {
    private final Map<UUID, Integer> blocos = new HashMap<UUID, Integer>();
    private final Map<UUID, Integer> xp = new HashMap<UUID, Integer>();
    private final Map<UUID, Integer> level = new HashMap<UUID, Integer>();
    private final Map<UUID, Double> cash = new HashMap<UUID, Double>();

    public int getBlocos(UUID uuid) {
        return this.blocos.getOrDefault(uuid, 0);
    }

    public void addBloco(UUID uuid) {
        this.addBlocos(uuid, 1);
    }

    public void addBlocos(UUID uuid, int amount) {
        if (amount <= 0) {
            return;
        }
        this.blocos.put(uuid, this.getBlocos(uuid) + amount);
    }

    public void setBlocos(UUID uuid, int amount) {
        if (amount < 0) {
            amount = 0;
        }
        this.blocos.put(uuid, amount);
    }

    public void removeBlocos(UUID uuid, int amount) {
        if (amount <= 0) {
            return;
        }
        int current = this.getBlocos(uuid);
        int newValue = current - amount;
        if (newValue < 0) {
            newValue = 0;
        }
        this.blocos.put(uuid, newValue);
    }

    public double getCash(UUID uuid) {
        return this.cash.getOrDefault(uuid, 0.0);
    }

    public void addCash(UUID uuid, double amount) {
        if (amount <= 0.0) {
            return;
        }
        this.cash.put(uuid, this.getCash(uuid) + amount);
    }

    public void setCash(UUID uuid, double amount) {
        if (amount < 0.0) {
            amount = 0.0;
        }
        this.cash.put(uuid, amount);
    }

    public void removeCash(UUID uuid, double amount) {
        if (amount <= 0.0) {
            return;
        }
        double current = this.getCash(uuid);
        double newValue = current - amount;
        if (newValue < 0.0) {
            newValue = 0.0;
        }
        this.cash.put(uuid, newValue);
    }

    public int getXP(UUID uuid) {
        return this.xp.getOrDefault(uuid, 0);
    }

    public void addXP(UUID uuid, int amount) {
        this.xp.put(uuid, this.getXP(uuid) + amount);
    }

    public void setXP(UUID uuid, int amount) {
        this.xp.put(uuid, Math.max(amount, 0));
    }

    public int getLevel(UUID uuid) {
        return this.level.getOrDefault(uuid, 1);
    }

    public void setLevel(UUID uuid, int lvl) {
        this.level.put(uuid, Math.max(lvl, 1));
    }

    public void saveAll() {
    }
}

