/*
 * Decompiled with CFR 0.152.
 */
package DL_Mina.managers;

import DL_Mina.DL_Mina;
import java.util.UUID;
import org.bukkit.entity.Player;

public class LevelManager {
    private final DL_Mina plugin;

    public LevelManager(DL_Mina plugin) {
        this.plugin = plugin;
    }

    public int getLevel(UUID uuid) {
        return this.plugin.getCacheManager().getLevel(uuid);
    }

    public double getXP(UUID uuid) {
        return this.plugin.getCacheManager().getXP(uuid);
    }

    public void addXP(Player player, double amount) {
        UUID uuid = player.getUniqueId();
        double newXP = this.getXP(uuid) + amount;
        this.plugin.getCacheManager().setXP(uuid, (int)newXP);
        this.checkLevelUp(player);
    }

    private void checkLevelUp(Player player) {
        UUID uuid = player.getUniqueId();
        int currentLevel = this.getLevel(uuid);
        if (!this.plugin.getConfig().getBoolean("levels.enabled")) {
            return;
        }
        if (!this.plugin.getConfig().getConfigurationSection("levels.requirements").contains(String.valueOf(currentLevel))) {
            return;
        }
        int requiredXP = this.plugin.getConfig().getInt("levels.requirements." + currentLevel);
        if (this.getXP(uuid) >= (double)requiredXP) {
            this.plugin.getCacheManager().setLevel(uuid, currentLevel + 1);
            player.sendMessage(player.getName() + " subiu para o n\u00edvel " + (currentLevel + 1));
        }
    }

    public double getLevelBonus(int level) {
        if (!this.plugin.getConfig().contains("levels.level-bonus." + level)) {
            return 0.0;
        }
        return this.plugin.getConfig().getDouble("levels.level-bonus." + level);
    }
}

