/*
 * Decompiled with CFR 0.152.
 */
package DL_Mina.managers;

import DL_Economy.DL_Economy;
import DL_Economy.managers.EconomyManager;
import DL_Mina.DL_Mina;
import DL_Mina.managers.UpgradeNPCManager;
import DL_Mina.objects.PlayerMine;
import DL_Mina.utils.InventoryManager;
import DL_Mina.utils.UpgradeMenu;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.GameRule;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.WorldType;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class MinaManager {
    private final DL_Mina plugin;
    private final EconomyManager economyManager;
    private final InventoryManager inventoryManager;
    private final UpgradeNPCManager npcManager;
    private final UpgradeMenu upgradeMenu;

    public MinaManager(DL_Mina plugin) {
        this.plugin = plugin;
        this.inventoryManager = new InventoryManager(plugin);
        this.npcManager = new UpgradeNPCManager(plugin);
        this.upgradeMenu = new UpgradeMenu(plugin);
        DL_Economy eco = (DL_Economy)Bukkit.getPluginManager().getPlugin("DL_Economy");
        if (eco != null && eco.isEnabled()) {
            this.economyManager = eco.getEconomyManager();
            plugin.getLogger().info("\u2705 DL_Economy detectado e integrado com sucesso!");
        } else {
            this.economyManager = null;
            plugin.getLogger().warning("\u26a0 DL_Economy n\u00e3o encontrado \u2014 o sistema usar\u00e1 custos simulados.");
        }
    }

    public void enterMine(Player player) {
        PlayerMine mine;
        UUID uuid = player.getUniqueId();
        String worldName = "mina_test_" + uuid.toString().substring(0, 8);
        World world = Bukkit.getWorld((String)worldName);
        if (world == null) {
            File baseWorld = new File(Bukkit.getWorldContainer(), "mina_test");
            File newWorld = new File(Bukkit.getWorldContainer(), worldName);
            this.copyWorld(baseWorld, newWorld);
            world = this.loadWorld(worldName);
            this.npcManager.createNPCForWorld(world);
        }
        if ((mine = this.plugin.getMineDataManager().getMine(uuid)) == null) {
            mine = new PlayerMine(uuid, new Location(world, -6.0, -24.0, 3.0), new Location(world, 22.0, -52.0, 15.0), 1);
            mine.setBlockLevel(1);
            this.plugin.getMineDataManager().saveMine(mine);
        }
        this.inventoryManager.saveInventory(player);
        this.givePickaxe(player);
        Location spawn = new Location(world, -37.8, -19.0, 10.9, -90.0f, 6.3f);
        player.teleport(spawn);
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            player.setAllowFlight(true);
            player.setFlying(true);
        }, 10L);
        player.sendMessage("\u00a7aVoc\u00ea entrou na sua mina privada!");
    }

    private void copyWorld(File source, File target) {
        if (!source.exists()) {
            this.plugin.getLogger().severe("\u274c Mundo base 'mina_test' n\u00e3o encontrado!");
            return;
        }
        if (target.exists()) {
            this.plugin.getLogger().info("\u267b\ufe0f Mundo " + target.getName() + " j\u00e1 existe, reutilizando...");
            return;
        }
        this.plugin.getLogger().info("\u26cf\ufe0f Clonando mapa base 'mina_test' -> " + target.getName());
        try {
            Files.walk(source.toPath(), new FileVisitOption[0]).forEach(path -> {
                try {
                    File dest = new File(target, path.toString().substring(source.toString().length()));
                    if (path.toFile().isDirectory()) {
                        dest.mkdirs();
                    } else {
                        Files.copy(path, dest.toPath(), new CopyOption[0]);
                    }
                }
                catch (IOException e) {
                    this.plugin.getLogger().warning("Erro ao copiar arquivo: " + e.getMessage());
                }
            });
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Falha ao copiar mundo: " + e.getMessage());
        }
        File uid = new File(target, "uid.dat");
        if (uid.exists()) {
            uid.delete();
        }
    }

    private World loadWorld(String name) {
        WorldCreator wc = new WorldCreator(name);
        wc.environment(World.Environment.NORMAL);
        wc.type(WorldType.FLAT);
        World world = wc.createWorld();
        if (world == null) {
            this.plugin.getLogger().severe("\u274c Falha ao carregar o mundo: " + name);
            return null;
        }
        world.setGameRule(GameRule.DO_DAYLIGHT_CYCLE, (Object)false);
        world.setGameRule(GameRule.DO_WEATHER_CYCLE, (Object)false);
        world.setGameRule(GameRule.DO_MOB_SPAWNING, (Object)false);
        world.setAutoSave(false);
        world.setTime(6000L);
        this.plugin.getLogger().info("\ud83d\udfe2 Mundo carregado com sucesso: " + name);
        return world;
    }

    public void resetMineWorld(World world, PlayerMine mine) {
        try {
            String baseName = "mina_test";
            File baseWorld = new File(Bukkit.getWorldContainer(), baseName);
            File playerWorld = world.getWorldFolder();
            this.plugin.getLogger().info("\u267b\ufe0f Resetando mundo da mina: " + world.getName());
            Bukkit.unloadWorld((World)world, (boolean)false);
            this.deleteWorldFolder(playerWorld);
            this.copyWorld(baseWorld, playerWorld);
            this.loadWorld(playerWorld.getName());
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Erro ao resetar mina: " + e.getMessage());
        }
    }

    public void leaveMine(Player player) {
        UUID uuid = player.getUniqueId();
        PlayerMine mine = this.plugin.getMineDataManager().getMine(uuid);
        if (mine != null) {
            this.plugin.getMineDataManager().saveMine(mine);
        }
        this.inventoryManager.restoreInventory(player);
        player.setAllowFlight(false);
        player.setFlying(false);
        String w = this.plugin.getConfig().getString("spawn-location.world", "world");
        double x = this.plugin.getConfig().getDouble("spawn-location.x", 0.0);
        double y = this.plugin.getConfig().getDouble("spawn-location.y", 80.0);
        double z = this.plugin.getConfig().getDouble("spawn-location.z", 0.0);
        float yaw = (float)this.plugin.getConfig().getDouble("spawn-location.yaw", 0.0);
        float pitch = (float)this.plugin.getConfig().getDouble("spawn-location.pitch", 0.0);
        player.teleport(new Location(Bukkit.getWorld((String)w), x, y, z, yaw, pitch));
        player.sendMessage("\u00a7eVoc\u00ea saiu da sua mina \u2014 progresso salvo!");
        String worldName = "mina_test_" + uuid.toString().substring(0, 8);
        World world = Bukkit.getWorld((String)worldName);
        if (world != null) {
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                if (world.getPlayers().isEmpty()) {
                    Bukkit.unloadWorld((World)world, (boolean)false);
                    this.deleteWorldFolder(world.getWorldFolder());
                    this.plugin.getLogger().info("\ud83c\udf0c Mundo privado removido: " + worldName);
                }
            }, 100L);
        }
    }

    public void handleMine(Player player) {
        UUID uuid = player.getUniqueId();
        this.plugin.getCacheManager().addBloco(uuid);
        PlayerMine mine = this.plugin.getMineDataManager().getMine(uuid);
        if (mine == null) {
            return;
        }
        double baseMoney = 5.0;
        double maxMoney = 135.0;
        double blockFactor = (double)(mine.getBlockLevel() - 1) / 9.0;
        double reward = baseMoney + (maxMoney - baseMoney) * blockFactor;
        double multiplier = this.plugin.getMultiplierManager().getTotalMultiplier(player);
        double finalMoney = reward * multiplier;
        if (this.economyManager != null) {
            this.economyManager.addBalance(uuid, "money", finalMoney);
            player.sendActionBar("\u00a7a+" + String.format("%.2f", finalMoney) + " coins");
        }
    }

    private void deleteWorldFolder(File folder) {
        try {
            Files.walk(folder.toPath(), new FileVisitOption[0]).sorted((a, b) -> b.compareTo((Path)a)).forEach(path -> path.toFile().delete());
        }
        catch (IOException e) {
            this.plugin.getLogger().warning("Erro ao deletar mundo: " + e.getMessage());
        }
    }

    public void upgradeMine(Player player, int amount) {
        PlayerMine mine = this.plugin.getMineDataManager().getMine(player.getUniqueId());
        if (mine == null || this.economyManager == null) {
            return;
        }
        for (int i = 0; i < amount; ++i) {
            int level = mine.getLevel();
            if (level >= 10) {
                player.sendMessage("\u00a7eSua mina j\u00e1 est\u00e1 no n\u00edvel m\u00e1ximo!");
                break;
            }
            double baseCost = this.plugin.getConfig().getDouble("blocks-upgrade.base-cost", 5000.0);
            double multiplier = this.plugin.getConfig().getDouble("blocks-upgrade.multiplier", 1.5);
            double cost = baseCost * Math.pow(multiplier, level - 1);
            double saldo = this.economyManager.getBalance(player.getUniqueId(), "money");
            if (saldo < cost) {
                player.sendMessage("\u00a7cVoc\u00ea precisa de \u00a76" + this.format(cost) + " money \u00a7cpara upar!");
                break;
            }
            this.economyManager.removeBalance(player.getUniqueId(), "money", cost);
            mine.upgrade();
            this.plugin.getMineDataManager().saveMine(mine);
            player.sendMessage("\u00a7a\u26cf Mina aprimorada para o n\u00edvel \u00a7e" + mine.getLevel());
            player.playSound(player.getLocation(), Sound.UI_TOAST_CHALLENGE_COMPLETE, 1.0f, 1.2f);
        }
    }

    public void upgradeMineBlocks(Player player) {
        PlayerMine mine = this.plugin.getMineDataManager().getMine(player.getUniqueId());
        if (mine == null || this.economyManager == null) {
            return;
        }
        int blockLevel = mine.getBlockLevel();
        if (blockLevel >= 10) {
            player.sendMessage("\u00a7eSeus blocos j\u00e1 est\u00e3o no n\u00edvel m\u00e1ximo!");
            return;
        }
        double baseCost = this.plugin.getConfig().getDouble("blocks-upgrade.base-cost", 7500.0);
        double multiplier = this.plugin.getConfig().getDouble("blocks-upgrade.multiplier", 1.5);
        double cost = baseCost * Math.pow(multiplier, blockLevel - 1);
        double saldo = this.economyManager.getBalance(player.getUniqueId(), "money");
        if (saldo < cost) {
            player.sendMessage("\u00a7cVoc\u00ea precisa de \u00a76" + this.format(cost) + " money \u00a7cpara upar seus blocos!");
            return;
        }
        this.economyManager.removeBalance(player.getUniqueId(), "money", cost);
        mine.upgradeBlockLevel();
        this.plugin.getMineDataManager().saveMine(mine);
        player.sendMessage("\u00a7b\u2728 Blocos evolu\u00eddos com sucesso!");
        player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_PLING, 1.0f, 1.4f);
    }

    public void openUpgradeMenu(Player player) {
        PlayerMine mine = this.plugin.getMineDataManager().getMine(player.getUniqueId());
        if (mine == null) {
            player.sendMessage("\u00a7cVoc\u00ea n\u00e3o possui uma mina!");
            return;
        }
        this.upgradeMenu.open(player);
    }

    public UpgradeMenu getUpgradeMenu() {
        return this.upgradeMenu;
    }

    public InventoryManager getInventoryManager() {
        return this.inventoryManager;
    }

    private void givePickaxe(Player player) {
        player.getInventory().clear();
        ItemStack pickaxe = new ItemStack(Material.NETHERITE_PICKAXE);
        ItemMeta meta = pickaxe.getItemMeta();
        meta.setDisplayName("\u00a76\u00a7lPicareta Suprema");
        meta.setUnbreakable(true);
        meta.addEnchant(Enchantment.EFFICIENCY, Integer.MAX_VALUE, true);
        pickaxe.setItemMeta(meta);
        player.getInventory().addItem(new ItemStack[]{pickaxe});
    }

    private String format(double value) {
        int index;
        String[] suffix = new String[]{"", "K", "M", "B", "T"};
        for (index = 0; value >= 1000.0 && index < suffix.length - 1; value /= 1000.0, ++index) {
        }
        return String.format("%.1f%s", value, suffix[index]);
    }
}

