/*
 * Decompiled with CFR 0.152.
 */
package DL_Mina.managers;

import DL_Mina.DL_Mina;
import DL_Mina.objects.PlayerMine;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.json.JSONArray;
import org.json.JSONObject;

public class MineDataManager {
    private final DL_Mina plugin;
    private final File file;
    private final Map<UUID, PlayerMine> mines = new HashMap<UUID, PlayerMine>();

    public MineDataManager(DL_Mina plugin) {
        this.plugin = plugin;
        this.file = new File(plugin.getDataFolder(), "mines.json");
        if (!plugin.getDataFolder().exists()) {
            plugin.getDataFolder().mkdirs();
        }
        if (!this.file.exists()) {
            try {
                this.file.createNewFile();
                try (FileWriter writer = new FileWriter(this.file);){
                    writer.write("[]");
                }
                plugin.getLogger().info("Arquivo mines.json criado!");
            }
            catch (IOException e) {
                plugin.getLogger().severe("Erro ao criar mines.json: " + e.getMessage());
            }
        }
        this.loadAll();
    }

    public void saveMine(PlayerMine mine) {
        this.mines.put(mine.getOwner(), mine);
        this.saveAll();
    }

    public PlayerMine getMine(UUID uuid) {
        return this.mines.get(uuid);
    }

    public Map<UUID, PlayerMine> getAllMines() {
        return this.mines;
    }

    public void loadAll() {
        if (!this.file.exists()) {
            return;
        }
        try (FileInputStream fis = new FileInputStream(this.file);){
            String content = new String(fis.readAllBytes(), StandardCharsets.UTF_8);
            if (content.isEmpty() || content.isBlank()) {
                return;
            }
            JSONArray array = new JSONArray(content);
            for (Object obj : array) {
                JSONObject json = (JSONObject)obj;
                UUID uuid = UUID.fromString(json.getString("owner"));
                String world = json.optString("world", "mina_test");
                Location start = new Location(Bukkit.getWorld((String)world), json.getDouble("startX"), json.getDouble("startY"), json.getDouble("startZ"));
                Location end = new Location(Bukkit.getWorld((String)world), json.getDouble("endX"), json.getDouble("endY"), json.getDouble("endZ"));
                int level = json.optInt("level", 1);
                int blockLevel = json.optInt("blockLevel", 1);
                PlayerMine mine = new PlayerMine(uuid, start, end, level);
                mine.setBlockLevel(blockLevel);
                this.mines.put(uuid, mine);
            }
            this.plugin.getLogger().info("\u00a7aMinas carregadas: " + this.mines.size());
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Erro ao carregar minas: " + e.getMessage());
        }
    }

    public void saveAll() {
        JSONArray array = new JSONArray();
        for (PlayerMine mine : this.mines.values()) {
            JSONObject json = new JSONObject();
            json.put("owner", mine.getOwner().toString());
            json.put("world", mine.getStart().getWorld().getName());
            json.put("startX", mine.getStart().getX());
            json.put("startY", mine.getStart().getY());
            json.put("startZ", mine.getStart().getZ());
            json.put("endX", mine.getEnd().getX());
            json.put("endY", mine.getEnd().getY());
            json.put("endZ", mine.getEnd().getZ());
            json.put("level", mine.getLevel());
            json.put("blockLevel", mine.getBlockLevel());
            array.put(json);
        }
        try (FileWriter writer = new FileWriter(this.file, false);){
            writer.write(array.toString(4));
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Erro ao salvar minas: " + e.getMessage());
        }
    }
}

