/*
 * Decompiled with CFR 0.152.
 */
package DL_Mina.managers;

import DL_Mina.DL_Mina;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Villager;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.event.world.WorldUnloadEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class UpgradeNPCManager
implements Listener {
    private final DL_Mina plugin;
    private final Map<UUID, Villager> npcByWorld = new HashMap<UUID, Villager>();

    public UpgradeNPCManager(DL_Mina plugin) {
        this.plugin = plugin;
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        Bukkit.getScheduler().runTaskLater((Plugin)plugin, () -> {
            for (World world : Bukkit.getWorlds()) {
                if (!this.isPrivateMineWorld(world)) continue;
                this.createNPCForWorld(world);
            }
        }, 40L);
    }

    @EventHandler
    public void onWorldLoad(WorldLoadEvent e) {
        World world = e.getWorld();
        if (this.isPrivateMineWorld(world)) {
            this.createNPCForWorld(world);
        }
    }

    @EventHandler
    public void onWorldUnload(WorldUnloadEvent e) {
        this.removeNPC(e.getWorld());
    }

    @EventHandler
    public void onNPCDeath(EntityDeathEvent e) {
        Villager v;
        LivingEntity livingEntity = e.getEntity();
        if (livingEntity instanceof Villager && (v = (Villager)livingEntity).getCustomName() != null && v.getCustomName().contains("Upgrade da Mina")) {
            World world = v.getWorld();
            if (!this.isPrivateMineWorld(world)) {
                return;
            }
            this.plugin.getLogger().warning("\u26a0 NPC de upgrade foi removido em " + world.getName() + ", recriando...");
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.createNPCForWorld(world), 40L);
        }
    }

    private boolean isPrivateMineWorld(World world) {
        return world.getName().startsWith("mina_test_");
    }

    public void createNPCForWorld(final World world) {
        Villager existing;
        if (world == null || !this.isPrivateMineWorld(world)) {
            return;
        }
        if (this.npcByWorld.containsKey(world.getUID()) && (existing = this.npcByWorld.get(world.getUID())) != null && !existing.isDead()) {
            this.plugin.getLogger().info("\u267b\ufe0f NPC j\u00e1 existente detectado em " + world.getName());
            return;
        }
        for (Entity entity : world.getEntities()) {
            Villager v;
            if (!(entity instanceof Villager) || (v = (Villager)entity).getCustomName() == null || !v.getCustomName().contains("Upgrade da Mina")) continue;
            this.configureNPC(v);
            this.npcByWorld.put(world.getUID(), v);
            this.plugin.getLogger().info("\u267b\ufe0f NPC reaproveitado no mundo '" + world.getName() + "'.");
            return;
        }
        new BukkitRunnable(){

            public void run() {
                final Location npcLoc = UpgradeNPCManager.this.getNpcSpawnLocation(world);
                if (npcLoc == null) {
                    return;
                }
                final Villager npc = (Villager)world.spawnEntity(npcLoc, EntityType.VILLAGER);
                UpgradeNPCManager.this.configureNPC(npc);
                UpgradeNPCManager.this.npcByWorld.put(world.getUID(), npc);
                UpgradeNPCManager.this.plugin.getLogger().info("\ud83d\udfe2 NPC criado no mundo '" + world.getName() + "'.");
                new BukkitRunnable(){

                    public void run() {
                        if (npc == null || npc.isDead() || !world.isChunkLoaded(npcLoc.getChunk())) {
                            this.cancel();
                            return;
                        }
                        Player nearest = null;
                        double nearestDist = Double.MAX_VALUE;
                        for (Player p : world.getPlayers()) {
                            double dist = p.getLocation().distanceSquared(npc.getLocation());
                            if (!(dist < nearestDist)) continue;
                            nearest = p;
                            nearestDist = dist;
                        }
                        if (nearest != null) {
                            Location npcLoc2 = npc.getLocation();
                            Location target = nearest.getLocation();
                            double dx = target.getX() - npcLoc2.getX();
                            double dz = target.getZ() - npcLoc2.getZ();
                            float yaw = (float)Math.toDegrees(Math.atan2(-dx, dz));
                            npcLoc2.setYaw(yaw);
                            npc.teleport(npcLoc2);
                        }
                    }
                }.runTaskTimer((Plugin)UpgradeNPCManager.this.plugin, 0L, 20L);
            }
        }.runTaskLater((Plugin)this.plugin, 20L);
    }

    private void configureNPC(Villager npc) {
        npc.setCustomName("\u00a76\u00a7l[Upgrade da Mina]");
        npc.setCustomNameVisible(true);
        npc.setAI(false);
        npc.setInvulnerable(true);
        npc.setSilent(true);
        npc.setGravity(false);
        npc.setPersistent(true);
        npc.setProfession(Villager.Profession.NITWIT);
    }

    private Location getNpcSpawnLocation(World world) {
        return new Location(world, -35.5, -19.0, 6.5);
    }

    public void removeNPC(World world) {
        Villager npc = this.npcByWorld.remove(world.getUID());
        if (npc != null && !npc.isDead()) {
            npc.remove();
        }
    }

    public void removeAll() {
        this.npcByWorld.values().forEach(v -> {
            if (v != null && !v.isDead()) {
                v.remove();
            }
        });
        this.npcByWorld.clear();
    }
}

