/*
 * Decompiled with CFR 0.152.
 */
package DL_Mina.objects;

import DL_Mina.DL_Mina;
import java.util.UUID;
import org.bukkit.Location;

public class PlayerMine {
    private final UUID owner;
    private Location start;
    private Location end;
    private int level;
    private int blockLevel = 1;

    public PlayerMine(UUID owner, Location start, Location end, int level) {
        this.owner = owner;
        this.start = start;
        this.end = end;
        this.level = level;
        this.blockLevel = 1;
    }

    public UUID getOwner() {
        return this.owner;
    }

    public Location getStart() {
        return this.start;
    }

    public Location getEnd() {
        return this.end;
    }

    public int getLevel() {
        return this.level;
    }

    public void upgrade() {
        if (this.level >= 10) {
            return;
        }
        ++this.level;
        this.start.subtract(2.0, 0.0, 2.0);
        this.end.add(2.0, 0.0, 2.0);
    }

    public void setLevel(int level) {
        this.level = Math.max(1, Math.min(level, 10));
    }

    public int getBlockLevel() {
        return this.blockLevel;
    }

    public void setBlockLevel(int level) {
        this.blockLevel = Math.max(1, Math.min(level, 10));
    }

    public void upgradeBlockLevel() {
        if (this.blockLevel < 10) {
            ++this.blockLevel;
        }
    }

    public void save(DL_Mina plugin) {
        plugin.getMineDataManager().saveMine(this);
    }
}

