/*
 * Decompiled with CFR 0.152.
 */
package DL_Mina.utils;

import DL_Mina.DL_Mina;
import DL_Mina.managers.MinaManager;
import DL_Mina.objects.PlayerMine;
import java.util.Arrays;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class UpgradeMenu {
    private final DL_Mina plugin;

    public UpgradeMenu(DL_Mina plugin) {
        this.plugin = plugin;
    }

    public void open(Player player) {
        PlayerMine mine = this.plugin.getMineDataManager().getMine(player.getUniqueId());
        if (mine == null) {
            player.sendMessage("\u00a7cVoc\u00ea n\u00e3o possui uma mina!");
            return;
        }
        Inventory inv = Bukkit.createInventory(null, (int)27, (String)"\u00a76\u00a7lUpgrades da Mina");
        int level = mine.getLevel();
        int nextLevel = Math.min(level + 1, 10);
        double cost = 5000.0 * Math.pow(1.5, level - 1);
        String custoMina = level >= 10 ? "\u00a7cN\u00edvel m\u00e1ximo" : "\u00a7a" + this.formatNumber(cost) + " money";
        Object proximoMina = level >= 10 ? "\u00a7cM\u00e1ximo" : "\u00a7b" + nextLevel;
        ItemStack upgradeMina = new ItemStack(Material.DIAMOND_PICKAXE);
        ItemMeta metaMina = upgradeMina.getItemMeta();
        metaMina.setDisplayName("\u00a7eUpgrade Mina \u00a77[" + level + "/10]");
        metaMina.setLore(Arrays.asList("\u00a77Aumente o tamanho da sua mina privada!", "", "\u00a7fCusto: " + custoMina, "\u00a7fN\u00edvel atual: \u00a7e" + level + "\u00a77/\u00a7a10", "\u00a7fPr\u00f3ximo n\u00edvel: " + (String)proximoMina, "", "\u00a7eBot\u00e3o esquerdo: \u00a77Upar 1 n\u00edvel", "\u00a7eBot\u00e3o direito: \u00a77Upar 3 n\u00edveis", "\u00a7eScroll (meio): \u00a77Upar o m\u00e1ximo poss\u00edvel"));
        upgradeMina.setItemMeta(metaMina);
        inv.setItem(11, upgradeMina);
        int blockLevel = mine.getBlockLevel();
        int nextBlockLevel = Math.min(blockLevel + 1, 10);
        double blockCost = 7500.0 * Math.pow(1.5, blockLevel - 1);
        String custoBloco = blockLevel >= 10 ? "\u00a7cN\u00edvel m\u00e1ximo" : "\u00a7a" + this.formatNumber(blockCost) + " money";
        Object proximoBloco = blockLevel >= 10 ? "\u00a7cM\u00e1ximo" : "\u00a7b" + nextBlockLevel;
        ItemStack upgradeBlocos = new ItemStack(Material.NETHERITE_BLOCK);
        ItemMeta metaBlocos = upgradeBlocos.getItemMeta();
        metaBlocos.setDisplayName("\u00a7bUpgrade de Blocos \u00a77[" + blockLevel + "/10]");
        metaBlocos.setLore(Arrays.asList("\u00a77Melhore os blocos da sua mina!", "", "\u00a7fCusto: " + custoBloco, "\u00a7fN\u00edvel atual: \u00a7e" + blockLevel + "\u00a77/\u00a7a10", "\u00a7fPr\u00f3ximo n\u00edvel: " + (String)proximoBloco, "", "\u00a7eClique esquerdo: \u00a77Upar 1 n\u00edvel"));
        upgradeBlocos.setItemMeta(metaBlocos);
        inv.setItem(15, upgradeBlocos);
        player.openInventory(inv);
    }

    public void handleClick(InventoryClickEvent e) {
        if (!e.getView().getTitle().contains("Upgrades da Mina")) {
            return;
        }
        e.setCancelled(true);
        HumanEntity humanEntity = e.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        ClickType clickType = e.getClick();
        PlayerMine mine = this.plugin.getMineDataManager().getMine(player.getUniqueId());
        if (mine == null) {
            return;
        }
        MinaManager minaManager = this.plugin.getMinaManager();
        int slot = e.getSlot();
        if (slot == 11) {
            if (clickType == ClickType.LEFT) {
                minaManager.upgradeMine(player, 1);
            } else if (clickType == ClickType.RIGHT) {
                minaManager.upgradeMine(player, 3);
            } else if (clickType == ClickType.MIDDLE) {
                minaManager.upgradeMine(player, 10);
            }
            player.playSound(player.getLocation(), Sound.UI_TOAST_CHALLENGE_COMPLETE, 1.0f, 1.2f);
            player.spawnParticle(Particle.HAPPY_VILLAGER, player.getLocation().add(0.0, 1.0, 0.0), 20, 0.3, 0.3, 0.3, 0.02);
        }
        if (slot == 15 && clickType == ClickType.LEFT) {
            minaManager.upgradeMineBlocks(player);
            player.playSound(player.getLocation(), Sound.BLOCK_ANVIL_USE, 1.0f, 1.1f);
        }
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.open(player), 5L);
    }

    private String formatNumber(double value) {
        int index;
        String[] suffix = new String[]{"", "K", "M", "B", "T"};
        for (index = 0; value >= 1000.0 && index < suffix.length - 1; value /= 1000.0, ++index) {
        }
        return String.format("%.1f%s", value, suffix[index]);
    }
}

