/*
 * Decompiled with CFR 0.152.
 */
package DL_Mina.utils;

import DL_Mina.DL_Mina;
import DL_Mina.objects.PlayerMine;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Villager;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class UpgradeNPCManager {
    private final DL_Mina plugin;
    private final Map<UUID, Villager> npcMap = new HashMap<UUID, Villager>();
    private final Location npcLocation = new Location(Bukkit.getWorld((String)"mina_test"), -35.49, -19.0, 14.45);

    public UpgradeNPCManager(DL_Mina plugin) {
        this.plugin = plugin;
    }

    public void spawnUpgradeNPC(PlayerMine mine, final Player player) {
        this.despawnNPC(player);
        World world = Bukkit.getWorld((String)"mina_test");
        if (world == null) {
            return;
        }
        final Villager npc = (Villager)world.spawnEntity(this.npcLocation, EntityType.VILLAGER);
        npc.setCustomName("\u00a76\u00a7l[Upgrade da Mina]");
        npc.setCustomNameVisible(true);
        npc.setAI(false);
        npc.setInvulnerable(true);
        npc.setProfession(Villager.Profession.ARMORER);
        this.npcMap.put(player.getUniqueId(), npc);
        new BukkitRunnable(){

            public void run() {
                if (!player.isOnline() || npc.isDead()) {
                    this.cancel();
                    UpgradeNPCManager.this.despawnNPC(player);
                    return;
                }
                Location playerLoc = player.getLocation();
                Location npcLoc = npc.getLocation();
                double dx = playerLoc.getX() - npcLoc.getX();
                double dy = playerLoc.getY() + 1.5 - (npcLoc.getY() + 1.5);
                double dz = playerLoc.getZ() - npcLoc.getZ();
                double distanceXZ = Math.sqrt(dx * dx + dz * dz);
                float yaw = (float)Math.toDegrees(Math.atan2(-dx, dz));
                float pitch = (float)Math.toDegrees(-Math.atan2(dy, distanceXZ));
                npcLoc.setYaw(yaw);
                npcLoc.setPitch(pitch);
                npc.teleport(npcLoc);
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 10L);
    }

    public void despawnNPC(Player player) {
        Villager npc = this.npcMap.remove(player.getUniqueId());
        if (npc != null && !npc.isDead()) {
            npc.remove();
        }
    }
}

