/*
 * Decompiled with CFR 0.152.
 */
package eu.decentsoftware.holograms.api.animations;

import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;

public abstract class Animation {
    private final String name;
    private final List<String> aliases;
    private final int speed;
    private final int pause;

    protected Animation(@NonNull String name, int speed, int pause) {
        this(name, speed, pause, new String[0]);
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
    }

    protected Animation(@NonNull String name, int speed, int pause, String ... aliases) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.name = name;
        this.speed = speed;
        this.pause = pause;
        this.aliases = Arrays.asList(aliases == null ? new String[]{} : aliases);
    }

    protected int getCurrentStep(long step, int maxSteps) {
        if (maxSteps <= 0) {
            return 0;
        }
        long actualStep = step / (long)this.speed;
        int actualPause = this.pause <= 0 ? 0 : this.pause / this.speed;
        int currentStep = (int)(actualStep % (long)(maxSteps + actualPause));
        return Math.min(currentStep, maxSteps);
    }

    public boolean isIdentifier(@NonNull String string) {
        if (string == null) {
            throw new NullPointerException("string is marked non-null but is null");
        }
        return this.name.equalsIgnoreCase(string) || this.aliases.contains(string.toLowerCase());
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public List<String> getAliases() {
        return this.aliases;
    }

    @Generated
    public int getSpeed() {
        return this.speed;
    }

    @Generated
    public int getPause() {
        return this.pause;
    }
}

