/*
 * Decompiled with CFR 0.152.
 */
package eu.decentsoftware.holograms.api.commands;

import eu.decentsoftware.holograms.api.Lang;
import eu.decentsoftware.holograms.api.commands.CommandBase;
import lombok.Generated;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public final class CommandValidator {
    public static Player getPlayer(CommandSender sender) {
        if (!(sender instanceof Player)) {
            Lang.ONLY_PLAYER.send(sender);
            return null;
        }
        return (Player)sender;
    }

    public static boolean isIdentifier(String identifier, CommandBase commandBase) {
        if (identifier.equalsIgnoreCase(commandBase.getName())) {
            return true;
        }
        for (String alias : commandBase.getAliases()) {
            if (!identifier.equalsIgnoreCase(alias)) continue;
            return true;
        }
        return false;
    }

    public static boolean canExecute(CommandSender sender, CommandBase commandBase) {
        if (commandBase.isPlayerOnly() && !(sender instanceof Player)) {
            Lang.ONLY_PLAYER.send(sender);
            return false;
        }
        String[] permissions = commandBase.getPermissions();
        if (permissions != null && permissions.length != 0) {
            if (sender.hasPermission("dh.admin")) {
                return true;
            }
            for (String permission : permissions) {
                if (!sender.hasPermission(permission)) continue;
                return true;
            }
            Lang.NO_PERM.send(sender);
            return false;
        }
        return true;
    }

    public static int getInteger(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException ex) {
            return -1;
        }
    }

    @Generated
    private CommandValidator() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

