/*
 * Decompiled with CFR 0.152.
 */
package eu.decentsoftware.holograms.api.utils;

import eu.decentsoftware.holograms.api.utils.Log;
import eu.decentsoftware.holograms.api.utils.color.IridiumColorAPI;
import eu.decentsoftware.holograms.semver.SemanticVersion;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.regex.Pattern;
import lombok.Generated;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.command.CommandSender;

public final class Common {
    public static final String NAME_REGEX = "[a-zA-Z0-9_-]+";
    private static final Pattern SPACING_CHARS_REGEX = Pattern.compile("[_ \\-]+");
    public static String PREFIX = "&8[&3DecentHolograms&8] &7";

    public static int randomInt(int min, int max) {
        return ThreadLocalRandom.current().nextInt(min, max + 1);
    }

    public static float randomFloat() {
        return ThreadLocalRandom.current().nextFloat();
    }

    public static String colorize(String string) {
        return IridiumColorAPI.process(string);
    }

    public static List<String> colorize(List<String> list) {
        list.replaceAll(Common::colorize);
        return list;
    }

    public static String stripColors(String string) {
        return ChatColor.stripColor((String)IridiumColorAPI.stripColorFormatting(string));
    }

    public static void tell(CommandSender player, String message) {
        player.sendMessage(Common.colorize(message));
    }

    public static void tell(CommandSender player, String message, Object ... args) {
        Common.tell(player, String.format(message, args));
    }

    public static String removeSpacingChars(String string) {
        if (string == null) {
            return null;
        }
        return SPACING_CHARS_REGEX.matcher(string).replaceAll("");
    }

    public static boolean isVersionHigher(String currentVersion, String newVersion) {
        try {
            SemanticVersion currentVersionSemantic = SemanticVersion.fromString(currentVersion);
            SemanticVersion newVersionSemantic = SemanticVersion.fromString(newVersion);
            return currentVersionSemantic.compareTo(newVersionSemantic) < 0;
        }
        catch (IllegalArgumentException e) {
            Log.warn("Failed to compare versions '%s' and '%s': %s", currentVersion, newVersion, e.getMessage());
            return false;
        }
    }

    @Generated
    private Common() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

