/*
 * Decompiled with CFR 0.152.
 */
package eu.decentsoftware.holograms.api.utils.tick;

import eu.decentsoftware.holograms.api.utils.Log;
import eu.decentsoftware.holograms.api.utils.scheduler.S;
import eu.decentsoftware.holograms.api.utils.tick.ITicked;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

public class Ticker {
    private final int taskId;
    private final AtomicLong ticks = new AtomicLong(0L);
    private final Map<String, ITicked> tickedObjects = new ConcurrentHashMap<String, ITicked>();
    private volatile boolean performingTick = false;

    public Ticker() {
        this.taskId = S.asyncTask(() -> {
            if (!this.performingTick) {
                this.tick();
            }
        }, 1L, 5L).getTaskId();
    }

    public void destroy() {
        S.stopTask(this.taskId);
        this.tickedObjects.clear();
    }

    public void register(ITicked ticked) {
        this.tickedObjects.put(ticked.getId(), ticked);
    }

    public void unregister(String id) {
        this.tickedObjects.remove(id);
    }

    private void tick() {
        this.performingTick = true;
        this.tickedObjects.forEach((id, ticked) -> {
            if (ticked.shouldTick(this.ticks.get())) {
                try {
                    ticked.tick();
                }
                catch (Exception ex) {
                    Log.warn("Failed to tick object %s of type %s.", ex, ticked.getId(), ticked.getClass().getSimpleName());
                }
            }
        });
        this.performingTick = false;
        this.ticks.incrementAndGet();
    }
}

