/*
 * Decompiled with CFR 0.152.
 */
package eu.decentsoftware.holograms.libs.xseries.profiles.gameprofile.property;

import com.google.common.collect.Multimap;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import eu.decentsoftware.holograms.libs.xseries.profiles.gameprofile.property.MojangProperty;
import eu.decentsoftware.holograms.libs.xseries.profiles.gameprofile.property.NewProperty;
import eu.decentsoftware.holograms.libs.xseries.profiles.gameprofile.property.OldProperty;
import eu.decentsoftware.holograms.libs.xseries.reflection.XReflection;
import java.lang.invoke.MethodHandle;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class XProperty {
    private static final boolean USE_RECORDS = XReflection.isRecord(Property.class);
    private static final MethodHandle PropertyMap$ctor = (MethodHandle)XReflection.of(PropertyMap.class).constructor().reflectOrNull();

    private XProperty() {
    }

    @NotNull
    public static MojangProperty of(Property property) {
        Objects.requireNonNull(property, "Property is null");
        if (USE_RECORDS) {
            return new NewProperty(property);
        }
        return new OldProperty(property);
    }

    public static MojangProperty create(String name, String value) {
        return XProperty.of(new Property(name, value));
    }

    public static MojangProperty create(String name, String value, String signature) {
        return XProperty.of(new Property(name, value, signature));
    }

    public static PropertyMap createPropertyMap(Multimap<String, Property> map) {
        if (PropertyMap$ctor == null) {
            return new PropertyMap(map);
        }
        try {
            PropertyMap propertyMap = PropertyMap$ctor.invokeExact();
            propertyMap.putAll(map);
            return propertyMap;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }
}

