/*
 * Decompiled with CFR 0.152.
 */
package eu.decentsoftware.holograms.libs.xseries.reflection.minecraft;

import eu.decentsoftware.holograms.libs.xseries.reflection.XReflection;
import eu.decentsoftware.holograms.libs.xseries.reflection.jvm.MethodMemberHandle;
import eu.decentsoftware.holograms.libs.xseries.reflection.minecraft.MinecraftClassHandle;
import eu.decentsoftware.holograms.libs.xseries.reflection.minecraft.MinecraftConnection;
import eu.decentsoftware.holograms.libs.xseries.reflection.minecraft.MinecraftMapping;
import eu.decentsoftware.holograms.libs.xseries.reflection.minecraft.MinecraftPackage;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.Chunk;
import org.bukkit.DyeColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;

public final class NMSExtras {
    public static final Class<?> EntityLiving = (Class)XReflection.ofMinecraft().inPackage(MinecraftPackage.NMS, "world.entity").map(MinecraftMapping.MOJANG, "LivingEntity").map(MinecraftMapping.SPIGOT, "EntityLiving").unreflect();
    private static final MethodHandle GET_ENTITY_HANDLE;
    public static final MethodHandle EXP_PACKET;
    public static final MethodHandle ENTITY_PACKET;
    public static final MethodHandle WORLD_HANDLE;
    public static final MethodHandle ENTITY_HANDLE;
    public static final MethodHandle LIGHTNING_ENTITY;
    public static final MethodHandle VEC3D;
    public static final MethodHandle GET_DATA_WATCHER;
    public static final MethodHandle DATA_WATCHER_GET_ITEM;
    public static final MethodHandle DATA_WATCHER_SET_ITEM;
    public static final MethodHandle PACKET_PLAY_OUT_OPEN_SIGN_EDITOR;
    public static final MethodHandle PACKET_PLAY_OUT_BLOCK_CHANGE;
    public static final MethodHandle ANIMATION_PACKET;
    public static final MethodHandle ANIMATION_TYPE;
    public static final MethodHandle ANIMATION_ENTITY_ID;
    public static final MethodHandle PLAY_OUT_MULTI_BLOCK_CHANGE_PACKET;
    public static final MethodHandle MULTI_BLOCK_CHANGE_INFO;
    public static final MethodHandle CHUNK_WRAPPER_SET;
    public static final MethodHandle CHUNK_WRAPPER;
    public static final MethodHandle SHORTS_OR_INFO;
    public static final MethodHandle SET_BlockState;
    public static final MethodHandle BLOCK_POSITION;
    public static final MethodHandle PLAY_BLOCK_ACTION;
    public static final MethodHandle GET_BUKKIT_ENTITY;
    public static final MethodHandle GET_BLOCK_TYPE;
    public static final MethodHandle GET_BLOCK;
    public static final MethodHandle GET_IBlockState;
    public static final MethodHandle SANITIZE_LINES;
    public static final MethodHandle TILE_ENTITY_SIGN;
    public static final MethodHandle TILE_ENTITY_SIGN__GET_UPDATE_PACKET;
    public static final MethodHandle TILE_ENTITY_SIGN__SET_LINE;
    public static final MethodHandle SIGN_TEXT;
    public static final Class<?> BlockState;
    public static final Class<?> MULTI_BLOCK_CHANGE_INFO_CLASS;

    private NMSExtras() {
    }

    public static void setExp(Player player, float bar, int lvl, int exp) {
        try {
            Object packet = EXP_PACKET.invoke(bar, lvl, exp);
            MinecraftConnection.sendPacket(player, packet);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    public static void lightning(Player player, Location location, boolean sound) {
        NMSExtras.lightning(Collections.singletonList(player), location, sound);
    }

    public static void lightning(Collection<Player> players, Location location, boolean sound) {
        try {
            Object world = WORLD_HANDLE.invoke(location.getWorld());
            if (!XReflection.supports(16)) {
                Object lightningBolt = LIGHTNING_ENTITY.invoke(world, location.getX(), location.getY(), location.getZ(), false, false);
                Object packet = ENTITY_PACKET.invoke(lightningBolt);
                for (Player player : players) {
                    MinecraftConnection.sendPacket(player, packet);
                }
            } else {
                Class nmsEntityType = (Class)XReflection.ofMinecraft().inPackage(MinecraftPackage.NMS, "world.entity").map(MinecraftMapping.MOJANG, "EntityType").map(MinecraftMapping.SPIGOT, "EntityTypes").unreflect();
                Object lightningType = nmsEntityType.getField(XReflection.supports(17) ? "U" : "LIGHTNING_BOLT").get(nmsEntityType);
                Object lightningBolt = LIGHTNING_ENTITY.invoke(lightningType, world);
                Object lightningBoltID = lightningBolt.getClass().getMethod("getId", new Class[0]).invoke(lightningBolt, new Object[0]);
                Object lightningBoltUUID = lightningBolt.getClass().getMethod("getUniqueID", new Class[0]).invoke(lightningBolt, new Object[0]);
                Object vec3D = VEC3D.invoke(0.0, 0.0, 0.0);
                Object packet = ENTITY_PACKET.invoke(lightningBoltID, lightningBoltUUID, location.getX(), location.getY(), location.getZ(), 0.0f, 0.0f, lightningType, 0, vec3D);
                for (Player player : players) {
                    MinecraftConnection.sendPacket(player, packet);
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static Object getData(Object dataWatcher, Object dataWatcherObject) {
        try {
            return DATA_WATCHER_GET_ITEM.invoke(dataWatcher, dataWatcherObject);
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("Failed to create data watcher", e);
        }
    }

    @Nullable
    public static Object getEntityHandle(Entity entity) {
        Objects.requireNonNull(entity, "Cannot get handle of null entity");
        try {
            return GET_ENTITY_HANDLE.invoke(entity);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public static Object getDataWatcher(Object handle) {
        try {
            return GET_DATA_WATCHER.invoke(handle);
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("Failed to get data watcher", e);
        }
    }

    public static Object setData(Object dataWatcher, Object dataWatcherObject, Object value) {
        try {
            return DATA_WATCHER_SET_ITEM.invoke(dataWatcher, dataWatcherObject, value);
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("Failed to set data watcher item", e);
        }
    }

    public static Object getStaticFieldIgnored(Class<?> clazz, String name) {
        return NMSExtras.getStaticField(clazz, name, true);
    }

    public static Object getStaticField(Class<?> clazz, String name, boolean silent) {
        try {
            Field field = clazz.getDeclaredField(name);
            field.setAccessible(true);
            return field.get(null);
        }
        catch (Throwable e) {
            if (!silent) {
                throw new IllegalArgumentException("Failed to get static field of " + clazz + " named " + name, e);
            }
            return null;
        }
    }

    public static void spinEntity(LivingEntity entity, boolean enabled) {
        if (!EntityPose.SPIN_ATTACK.isSupported()) {
            throw new UnsupportedOperationException("Spin attacks are not supported in " + XReflection.getVersionInformation());
        }
        NMSExtras.setLivingEntityFlag((Entity)entity, LivingEntityFlags.SPIN_ATTACK.getBit(), enabled);
    }

    public static void setLivingEntityFlag(Entity entity, int index, boolean flag) {
        Object handle = NMSExtras.getEntityHandle(entity);
        Object dataWatcher = NMSExtras.getDataWatcher(handle);
        Object flagItem = DataWatcherItemType.DATA_LIVING_ENTITY_FLAGS.getId();
        byte currentFlags = (Byte)NMSExtras.getData(dataWatcher, flagItem);
        int newFlags = flag ? currentFlags | index : currentFlags & ~index;
        NMSExtras.setData(dataWatcher, flagItem, (byte)newFlags);
    }

    public static boolean hasLivingEntityFlag(Entity entity, int index) {
        Object handle = NMSExtras.getEntityHandle(entity);
        Object dataWatcher = NMSExtras.getDataWatcher(handle);
        byte flags = (Byte)NMSExtras.getData(dataWatcher, DataWatcherItemType.DATA_LIVING_ENTITY_FLAGS.getId());
        return (flags & index) != 0;
    }

    public boolean isAutoSpinAttack(LivingEntity entity) {
        return NMSExtras.hasLivingEntityFlag((Entity)entity, LivingEntityFlags.SPIN_ATTACK.getBit());
    }

    public static void animation(Collection<? extends Player> players, LivingEntity entity, Animation animation) {
        try {
            Object packet;
            if (XReflection.supports(17)) {
                packet = ANIMATION_PACKET.invoke(ENTITY_HANDLE.invoke(entity), animation.ordinal());
            } else {
                packet = ANIMATION_PACKET.invoke();
                ANIMATION_TYPE.invoke(packet, animation.ordinal());
                ANIMATION_ENTITY_ID.invoke(packet, entity.getEntityId());
            }
            for (Player player : players) {
                MinecraftConnection.sendPacket(player, packet);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static void chest(Block chest, boolean open) {
        Location location = chest.getLocation();
        try {
            Object world = WORLD_HANDLE.invoke(location.getWorld());
            Object position = XReflection.v(19, () -> {
                try {
                    return BLOCK_POSITION.invoke(location.getBlockX(), location.getBlockY(), location.getBlockZ());
                }
                catch (Throwable e) {
                    throw new IllegalArgumentException("Failed to set block position", e);
                }
            }).orElse(() -> {
                try {
                    return BLOCK_POSITION.invoke(location.getX(), location.getY(), location.getZ());
                }
                catch (Throwable e) {
                    throw new IllegalArgumentException("Failed to set block position", e);
                }
            });
            Object block = GET_BLOCK.invoke(GET_BLOCK_TYPE.invoke(world, position));
            PLAY_BLOCK_ACTION.invoke(world, position, block, 1, open ? 1 : 0);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    @Deprecated
    protected static void sendBlockChange(Player player, Chunk chunk, Map<WorldlessBlockWrapper, Object> blocks) {
        try {
            Object packet = PLAY_OUT_MULTI_BLOCK_CHANGE_PACKET.invoke();
            if (XReflection.supports(16)) {
                Object wrapper = CHUNK_WRAPPER.invoke(chunk.getX(), chunk.getZ());
                CHUNK_WRAPPER_SET.invoke(wrapper);
                Object dataArray = Array.newInstance(BlockState, blocks.size());
                Object shortArray = Array.newInstance(Short.TYPE, blocks.size());
                int i = 0;
                for (Map.Entry<WorldlessBlockWrapper, Object> entry : blocks.entrySet()) {
                    Block loc = entry.getKey().block;
                    int x = loc.getX() & 0xF;
                    int y = loc.getY() & 0xF;
                    int z = loc.getZ() & 0xF;
                    ++i;
                }
                SHORTS_OR_INFO.invoke(packet, shortArray);
                SET_BlockState.invoke(packet, dataArray);
            } else {
                Object wrapper = CHUNK_WRAPPER.invoke(chunk.getX(), chunk.getZ());
                CHUNK_WRAPPER_SET.invoke(wrapper);
                Object array = Array.newInstance(MULTI_BLOCK_CHANGE_INFO_CLASS, blocks.size());
                int i = 0;
                for (Map.Entry<WorldlessBlockWrapper, Object> entry : blocks.entrySet()) {
                    Block loc = entry.getKey().block;
                    int x = loc.getX() & 0xF;
                    int z = loc.getZ() & 0xF;
                    ++i;
                }
                SHORTS_OR_INFO.invoke(packet, array);
            }
            MinecraftConnection.sendPacket(player, packet);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static void openSign(Player player, DyeColor textColor, String[] lines, boolean frontSide) {
        try {
            Location loc = player.getLocation();
            Object position = BLOCK_POSITION.invoke(loc.getBlockX(), 1, loc.getBlockY());
            Object signBlockData = GET_IBlockState.invoke(Material.OAK_SIGN, (byte)0);
            Object blockChangePacket = PACKET_PLAY_OUT_BLOCK_CHANGE.invoke(position, signBlockData);
            Object components = SANITIZE_LINES.invoke(lines);
            Object tileSign = TILE_ENTITY_SIGN.invoke(position, signBlockData);
            if (XReflection.supports(20)) {
                Class EnumColor = (Class)XReflection.ofMinecraft().inPackage(MinecraftPackage.NMS, "world.item").map(MinecraftMapping.MOJANG, "DyeColor").map(MinecraftMapping.SPIGOT, "EnumColor").unreflect();
                Object enumColor = null;
                for (Field field : EnumColor.getFields()) {
                    Object color = field.get(null);
                    String colorName = (String)EnumColor.getDeclaredMethod("b", new Class[0]).invoke(color, new Object[0]);
                    if (!textColor.name().equalsIgnoreCase(colorName)) continue;
                    enumColor = color;
                    break;
                }
                Object signText = SIGN_TEXT.invoke(components, components, enumColor, frontSide);
                TILE_ENTITY_SIGN__SET_LINE.invoke(signText, true);
            } else {
                for (int i = 0; i < lines.length; ++i) {
                    Object component = Array.get(components, i);
                    TILE_ENTITY_SIGN__SET_LINE.invoke(tileSign, i, component, component);
                }
            }
            Object signLinesUpdatePacket = TILE_ENTITY_SIGN__GET_UPDATE_PACKET.invoke(tileSign);
            Object signPacket = XReflection.v(20, PACKET_PLAY_OUT_OPEN_SIGN_EDITOR.invoke(position, true)).orElse(PACKET_PLAY_OUT_OPEN_SIGN_EDITOR.invoke(position));
            MinecraftConnection.sendPacket(player, blockChangePacket, signLinesUpdatePacket, signPacket);
        }
        catch (Throwable x) {
            x.printStackTrace();
        }
    }

    static {
        BlockState = (Class)XReflection.ofMinecraft().inPackage(MinecraftPackage.NMS, "world.level.block.state").map(MinecraftMapping.MOJANG, "BlockState").map(MinecraftMapping.SPIGOT, "IBlockData").unreflect();
        MULTI_BLOCK_CHANGE_INFO_CLASS = null;
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        MethodHandle expPacket = null;
        MethodHandle entityPacket = null;
        MethodHandle worldHandle = null;
        MethodHandle entityHandle = null;
        MethodHandle lightning = null;
        MethodHandle vec3D = null;
        MethodHandle signEditorPacket = null;
        MethodHandle packetPlayOutBlockChange = null;
        MethodHandle animationPacket = null;
        MethodHandle animationType = null;
        MethodHandle animationEntityId = null;
        MethodHandle getBukkitEntity = null;
        MethodHandle blockPosition = null;
        MethodHandle playBlockAction = null;
        MethodHandle getBlockType = null;
        MethodHandle getBlock = null;
        MethodHandle getIBlockData = null;
        MethodHandle sanitizeLines = null;
        MethodHandle tileEntitySign = null;
        MethodHandle tileEntitySign_getUpdatePacket = null;
        MethodHandle tileEntitySign_setLine = null;
        MethodHandle signText = null;
        Object playOutMultiBlockChange = null;
        Object multiBlockChangeInfo = null;
        MethodHandle chunkWrapper = null;
        Object chunkWrapperSet = null;
        Object shortsOrInfo = null;
        Object setBlockData = null;
        MethodHandle getDataWatcher = null;
        MethodHandle dataWatcherGetItem = null;
        MethodHandle dataWatcherSetItem = null;
        MethodHandle getHandle = null;
        try {
            Class CraftEntityClass = (Class)XReflection.ofMinecraft().inPackage(MinecraftPackage.CB, "entity").named("CraftEntity").unreflect();
            Class nmsEntityType = (Class)XReflection.ofMinecraft().inPackage(MinecraftPackage.NMS, "world.entity").map(MinecraftMapping.MOJANG, "EntityType").map(MinecraftMapping.SPIGOT, "EntityTypes").unreflect();
            Class nmsEntity = (Class)XReflection.ofMinecraft().inPackage(MinecraftPackage.NMS, "world.entity").named("Entity").unreflect();
            Class craftEntity = (Class)XReflection.ofMinecraft().inPackage(MinecraftPackage.CB, "entity").named("CraftEntity").unreflect();
            Class nmsVec3D = (Class)XReflection.ofMinecraft().inPackage(MinecraftPackage.NMS, "world.phys").map(MinecraftMapping.MOJANG, "Vec3").map(MinecraftMapping.SPIGOT, "Vec3D").unreflect();
            Class world = (Class)XReflection.ofMinecraft().inPackage(MinecraftPackage.NMS, "world.level").map(MinecraftMapping.MOJANG, "Level").map(MinecraftMapping.SPIGOT, "World").unreflect();
            Class signOpenPacket = (Class)XReflection.ofMinecraft().inPackage(MinecraftPackage.NMS, "network.protocol.game").map(MinecraftMapping.MOJANG, "ClientboundOpenSignEditorPacket").map(MinecraftMapping.SPIGOT, "PacketPlayOutOpenSignEditor").unreflect();
            Class packetPlayOutBlockChangeClass = (Class)XReflection.ofMinecraft().inPackage(MinecraftPackage.NMS, "network.protocol.game").map(MinecraftMapping.MOJANG, "ClientboundBlockUpdatePacket").map(MinecraftMapping.SPIGOT, "PacketPlayOutBlockChange").unreflect();
            Class CraftMagicNumbers = (Class)XReflection.ofMinecraft().inPackage(MinecraftPackage.CB, "util").named("CraftMagicNumbers").unreflect();
            Class CraftSign = (Class)XReflection.ofMinecraft().inPackage(MinecraftPackage.CB, "block").named("CraftSign").unreflect();
            Class IChatBaseComponent2 = (Class)XReflection.ofMinecraft().inPackage(MinecraftPackage.NMS, "network.chat").map(MinecraftMapping.MOJANG, "Component").map(MinecraftMapping.SPIGOT, "IChatBaseComponent").unreflect();
            Class TileEntitySign = (Class)XReflection.ofMinecraft().inPackage(MinecraftPackage.NMS, "world.level.block.entity").map(MinecraftMapping.MOJANG, "SignBlockEntity").map(MinecraftMapping.SPIGOT, "TileEntitySign").unreflect();
            Class PacketPlayOutTileEntityData = (Class)XReflection.ofMinecraft().inPackage(MinecraftPackage.NMS, "network.protocol.game").map(MinecraftMapping.MOJANG, "ClientboundBlockEntityDataPacket").map(MinecraftMapping.SPIGOT, "PacketPlayOutTileEntityData").unreflect();
            Class DataWatcherClass = (Class)XReflection.ofMinecraft().inPackage(MinecraftPackage.NMS, "network.syncher").map(MinecraftMapping.MOJANG, "SynchedEntityData").map(MinecraftMapping.SPIGOT, "DataWatcher").unreflect();
            Class DataWatcherItemClass = (Class)XReflection.ofMinecraft().inPackage(MinecraftPackage.NMS, "network.syncher").map(MinecraftMapping.MOJANG, "SynchedEntityData$DataItem").map(MinecraftMapping.SPIGOT, "DataWatcher$Item").unreflect();
            Class DataWatcherObject2 = (Class)XReflection.ofMinecraft().inPackage(MinecraftPackage.NMS, "network.syncher").map(MinecraftMapping.MOJANG, "EntityDataAccessor").map(MinecraftMapping.SPIGOT, "DataWatcherObject").unreflect();
            getHandle = lookup.findVirtual(CraftEntityClass, "getHandle", MethodType.methodType(nmsEntity));
            getDataWatcher = (MethodHandle)((MethodMemberHandle)XReflection.of(nmsEntity).method().returns(DataWatcherClass)).map(MinecraftMapping.MOJANG, "getEntityData").map(MinecraftMapping.OBFUSCATED, XReflection.v(21, 9, "aC").v(21, 6, "au").v(21, 5, "ar").v(21, 3, "au").v(21, "ar").v(20, 5, "ap").v(20, 4, "an").v(20, 2, "al").v(19, "aj").v(18, "ai").orElse("getDataWatcher")).unreflect();
            dataWatcherGetItem = (MethodHandle)((MethodMemberHandle)XReflection.of(DataWatcherClass).method().returns((Class)Object.class)).parameters(DataWatcherObject2).map(MinecraftMapping.MOJANG, "get").map(MinecraftMapping.SPIGOT, XReflection.v(20, 5, "a").v(20, "b").v(18, "a").orElse("get")).unreflect();
            dataWatcherSetItem = (MethodHandle)((MethodMemberHandle)XReflection.of(DataWatcherClass).method().returns((Class)Void.TYPE)).parameters(DataWatcherObject2, Object.class).map(MinecraftMapping.MOJANG, "set").map(MinecraftMapping.SPIGOT, XReflection.v(20, 5, "a").v(18, "b").orElse("set")).unreflect();
            getBukkitEntity = lookup.findVirtual(nmsEntity, "getBukkitEntity", MethodType.methodType(craftEntity));
            entityHandle = lookup.findVirtual(craftEntity, "getHandle", MethodType.methodType(nmsEntity));
            expPacket = lookup.findConstructor((Class)XReflection.ofMinecraft().inPackage(MinecraftPackage.NMS, "network.protocol.game").map(MinecraftMapping.MOJANG, "ClientboundSetExperiencePacket").map(MinecraftMapping.SPIGOT, "PacketPlayOutExperience").unreflect(), MethodType.methodType(Void.TYPE, Float.TYPE, Integer.TYPE, Integer.TYPE));
            if (!XReflection.supports(16)) {
                entityPacket = (MethodHandle)XReflection.ofMinecraft().inPackage(MinecraftPackage.NMS).named("PacketPlayOutSpawnEntityWeather").constructor().parameters(nmsEntity).unreflect();
            } else {
                vec3D = lookup.findConstructor(nmsVec3D, MethodType.methodType(Void.TYPE, Double.TYPE, Double.TYPE, Double.TYPE));
                ArrayList spawnTypes = new ArrayList(Arrays.asList(Integer.TYPE, UUID.class, Double.TYPE, Double.TYPE, Double.TYPE, Float.TYPE, Float.TYPE, nmsEntityType, Integer.TYPE, nmsVec3D));
                if (XReflection.supports(19)) {
                    spawnTypes.add(Double.TYPE);
                }
                entityPacket = lookup.findConstructor((Class)XReflection.ofMinecraft().inPackage(MinecraftPackage.NMS, "network.protocol.game").map(MinecraftMapping.MOJANG, "ClientboundAddEntityPacket").map(MinecraftMapping.SPIGOT, "PacketPlayOutSpawnEntity").unreflect(), MethodType.methodType(Void.TYPE, spawnTypes));
            }
            worldHandle = lookup.findVirtual((Class)XReflection.ofMinecraft().inPackage(MinecraftPackage.CB).named("CraftWorld").unreflect(), "getHandle", MethodType.methodType((Class)XReflection.ofMinecraft().inPackage(MinecraftPackage.NMS, "server.level").map(MinecraftMapping.MOJANG, "ServerLevel").map(MinecraftMapping.SPIGOT, "WorldServer").unreflect()));
            MinecraftClassHandle entityLightning = XReflection.ofMinecraft().inPackage(MinecraftPackage.NMS, "world.entity").map(MinecraftMapping.MOJANG, "LightningBolt").map(MinecraftMapping.SPIGOT, "EntityLightning");
            lightning = !XReflection.supports(16) ? lookup.findConstructor((Class)entityLightning.unreflect(), MethodType.methodType(Void.TYPE, world, Double.TYPE, Double.TYPE, Double.TYPE, Boolean.TYPE, Boolean.TYPE)) : lookup.findConstructor((Class)entityLightning.unreflect(), MethodType.methodType(Void.TYPE, nmsEntityType, world));
            Class playOutMultiBlockChangeClass = (Class)XReflection.ofMinecraft().inPackage(MinecraftPackage.NMS, "network.protocol.game").map(MinecraftMapping.MOJANG, "ClientboundSectionBlocksUpdatePacket").map(MinecraftMapping.SPIGOT, "PacketPlayOutMultiBlockChange").unreflect();
            Class chunkCoordIntPairClass = (Class)XReflection.ofMinecraft().inPackage(MinecraftPackage.NMS, "world.level").map(MinecraftMapping.MOJANG, "ChunkPos").map(MinecraftMapping.SPIGOT, "ChunkCoordIntPair").unreflect();
            try {
                if (!XReflection.supports(16)) {
                    chunkWrapper = lookup.findConstructor(chunkCoordIntPairClass, MethodType.methodType(Void.TYPE, Integer.TYPE, Integer.TYPE));
                }
            }
            catch (IllegalAccessException | NoSuchMethodException e) {
                e.printStackTrace();
            }
            Class animation = (Class)XReflection.ofMinecraft().inPackage(MinecraftPackage.NMS, "network.protocol.game").map(MinecraftMapping.MOJANG, "ClientboundAnimatePacket").map(MinecraftMapping.SPIGOT, "PacketPlayOutAnimation").unreflect();
            animationPacket = lookup.findConstructor(animation, XReflection.supports(17) ? MethodType.methodType(Void.TYPE, nmsEntity, Integer.TYPE) : MethodType.methodType(Void.TYPE));
            if (!XReflection.supports(17)) {
                Field field = animation.getDeclaredField("a");
                field.setAccessible(true);
                animationEntityId = lookup.unreflectSetter(field);
                field = animation.getDeclaredField("b");
                field.setAccessible(true);
                animationType = lookup.unreflectSetter(field);
            }
            Class blockPos = (Class)XReflection.ofMinecraft().inPackage(MinecraftPackage.NMS, "core").map(MinecraftMapping.MOJANG, "BlockPos").map(MinecraftMapping.SPIGOT, "BlockPosition").unreflect();
            Class block = (Class)XReflection.ofMinecraft().inPackage(MinecraftPackage.NMS, "world.level.block").named("Block").unreflect();
            blockPosition = lookup.findConstructor(blockPos, XReflection.v(19, MethodType.methodType(Void.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE)).orElse(MethodType.methodType(Void.TYPE, Double.TYPE, Double.TYPE, Double.TYPE)));
            getBlockType = (MethodHandle)((MethodMemberHandle)XReflection.of(world).method().returns((Class)BlockState)).parameters(blockPos).map(MinecraftMapping.MOJANG, "getBlockState").map(MinecraftMapping.SPIGOT, XReflection.v(18, "a_").orElse("getType")).unreflect();
            getBlock = XReflection.supports(21) ? (MethodHandle)((MethodMemberHandle)XReflection.ofMinecraft().inPackage(MinecraftPackage.NMS, "world.level.block.state").map(MinecraftMapping.MOJANG, "BlockBehaviour").map(MinecraftMapping.SPIGOT, "BlockBase").inner(XReflection.ofMinecraft().map(MinecraftMapping.MOJANG, "BlockStateBase").map(MinecraftMapping.SPIGOT, "BlockData")).method().returns(block)).map(MinecraftMapping.MOJANG, "getBlock").map(MinecraftMapping.SPIGOT, "b").unreflect() : (MethodHandle)((MethodMemberHandle)XReflection.of(BlockState).method().returns(block)).map(MinecraftMapping.MOJANG, "getBlock").map(MinecraftMapping.SPIGOT, XReflection.v(18, "b").orElse("getBlock")).unreflect();
            playBlockAction = (MethodHandle)((MethodMemberHandle)XReflection.of(world).method().returns((Class)Void.TYPE)).parameters(blockPos, block, Integer.TYPE, Integer.TYPE).map(MinecraftMapping.MOJANG, "blockEvent").map(MinecraftMapping.SPIGOT, XReflection.v(18, "a").orElse("playBlockAction")).unreflect();
            signEditorPacket = lookup.findConstructor(signOpenPacket, XReflection.v(20, MethodType.methodType(Void.TYPE, blockPos, Boolean.TYPE)).orElse(MethodType.methodType(Void.TYPE, blockPos)));
            if (XReflection.supports(17)) {
                packetPlayOutBlockChange = lookup.findConstructor(packetPlayOutBlockChangeClass, MethodType.methodType(Void.TYPE, blockPos, BlockState));
                getIBlockData = lookup.findStatic(CraftMagicNumbers, "getBlock", MethodType.methodType(BlockState, Material.class, Byte.TYPE));
                sanitizeLines = lookup.findStatic(CraftSign, XReflection.v(17, "sanitizeLines").orElse("SANITIZE_LINES"), MethodType.methodType(XReflection.toArrayClass(IChatBaseComponent2), String[].class));
                tileEntitySign = lookup.findConstructor(TileEntitySign, MethodType.methodType(Void.TYPE, blockPos, BlockState));
                tileEntitySign_getUpdatePacket = (MethodHandle)((MethodMemberHandle)XReflection.of(TileEntitySign).method().returns(PacketPlayOutTileEntityData)).map(MinecraftMapping.MOJANG, "getUpdatePacket").map(MinecraftMapping.SPIGOT, XReflection.v(21, 9, "l").v(21, 6, "u").v(21, 4, "s").v(21, 3, "t").v(20, 5, "l").v(20, 4, "m").v(20, "j").v(19, "f").v(18, "c").orElse("getUpdatePacket")).unreflect();
                if (XReflection.supports(20)) {
                    Class SignText = (Class)XReflection.ofMinecraft().inPackage(MinecraftPackage.NMS, "world.level.block.entity").named("SignText").unreflect();
                    if (!XReflection.supports(20, 6)) {
                        tileEntitySign_setLine = lookup.findVirtual(TileEntitySign, "a", MethodType.methodType(Boolean.TYPE, SignText, Boolean.TYPE));
                    }
                    Class IChatBaseComponentArray = (Class)XReflection.of(IChatBaseComponent2).asArray().unreflect();
                    Class EnumColor = (Class)XReflection.ofMinecraft().inPackage(MinecraftPackage.NMS, "world.item").map(MinecraftMapping.MOJANG, "DyeColor").map(MinecraftMapping.SPIGOT, "EnumColor").unreflect();
                    signText = lookup.findConstructor(SignText, MethodType.methodType(Void.TYPE, IChatBaseComponentArray, IChatBaseComponentArray, EnumColor, Boolean.TYPE));
                } else {
                    tileEntitySign_setLine = lookup.findVirtual(TileEntitySign, "a", MethodType.methodType(Void.TYPE, Integer.TYPE, IChatBaseComponent2, IChatBaseComponent2));
                }
            }
        }
        catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException ex) {
            ex.printStackTrace();
        }
        GET_ENTITY_HANDLE = getHandle;
        GET_DATA_WATCHER = getDataWatcher;
        DATA_WATCHER_GET_ITEM = dataWatcherGetItem;
        DATA_WATCHER_SET_ITEM = dataWatcherSetItem;
        EXP_PACKET = expPacket;
        ENTITY_PACKET = entityPacket;
        WORLD_HANDLE = worldHandle;
        ENTITY_HANDLE = entityHandle;
        LIGHTNING_ENTITY = lightning;
        VEC3D = vec3D;
        PACKET_PLAY_OUT_OPEN_SIGN_EDITOR = signEditorPacket;
        PACKET_PLAY_OUT_BLOCK_CHANGE = packetPlayOutBlockChange;
        ANIMATION_PACKET = animationPacket;
        ANIMATION_TYPE = animationType;
        ANIMATION_ENTITY_ID = animationEntityId;
        BLOCK_POSITION = blockPosition;
        PLAY_BLOCK_ACTION = playBlockAction;
        GET_BLOCK_TYPE = getBlockType;
        GET_BLOCK = getBlock;
        GET_IBlockState = getIBlockData;
        SANITIZE_LINES = sanitizeLines;
        TILE_ENTITY_SIGN = tileEntitySign;
        TILE_ENTITY_SIGN__GET_UPDATE_PACKET = tileEntitySign_getUpdatePacket;
        TILE_ENTITY_SIGN__SET_LINE = tileEntitySign_setLine;
        GET_BUKKIT_ENTITY = getBukkitEntity;
        PLAY_OUT_MULTI_BLOCK_CHANGE_PACKET = playOutMultiBlockChange;
        MULTI_BLOCK_CHANGE_INFO = multiBlockChangeInfo;
        CHUNK_WRAPPER = chunkWrapper;
        CHUNK_WRAPPER_SET = chunkWrapperSet;
        SHORTS_OR_INFO = shortsOrInfo;
        SET_BlockState = setBlockData;
        SIGN_TEXT = signText;
    }

    public static enum EntityPose {
        STANDING("a"),
        FALL_FLYING("b"),
        SLEEPING("c"),
        SWIMMING("d"),
        SPIN_ATTACK("e"),
        CROUCHING("f"),
        LONG_JUMPING("g"),
        DYING("h"),
        CROAKING("i"),
        USING_TONGUE("j"),
        SITTING("k"),
        ROARING("l"),
        SNIFFING("m"),
        EMERGING("n"),
        DIGGING("o");

        public final Object enumValue;
        private final boolean supported;

        private EntityPose(String fieldName) {
            boolean supported = true;
            Object enumValue = null;
            try {
                Object EntityPose2 = XReflection.ofMinecraft().inPackage(MinecraftPackage.NMS, "world.entity").map(MinecraftMapping.MOJANG, "Pose").map(MinecraftMapping.SPIGOT, "EntityPose").reflect();
                enumValue = ((Class)EntityPose2).getDeclaredField(XReflection.v(17, fieldName).orElse(this.name())).get(null);
            }
            catch (Throwable e) {
                supported = false;
            }
            this.supported = supported;
            this.enumValue = enumValue;
        }

        public boolean isSupported() {
            return this.supported;
        }

        public Object getEnumValue() {
            return this.enumValue;
        }
    }

    public static enum LivingEntityFlags {
        SPIN_ATTACK(4);

        private final byte bit;

        private LivingEntityFlags(int bit) {
            this.bit = (byte)bit;
        }

        public byte getBit() {
            return this.bit;
        }
    }

    public static enum DataWatcherItemType {
        DATA_LIVING_ENTITY_FLAGS(NMSExtras.getStaticFieldIgnored(EntityLiving, "t"));

        private final Object id;
        private final boolean supported;

        private DataWatcherItemType(Object DataWatcherObject2) {
            boolean supported = true;
            Object id = null;
            try {
                id = DataWatcherObject2;
            }
            catch (Throwable e) {
                supported = false;
            }
            this.supported = supported;
            this.id = id;
        }

        public boolean isSupported() {
            return this.supported;
        }

        public Object getId() {
            return this.id;
        }
    }

    public static enum Animation {
        SWING_MAIN_ARM,
        HURT,
        LEAVE_BED,
        SWING_OFF_HAND,
        CRITICAL_EFFECT,
        MAGIC_CRITICAL_EFFECT;

    }

    public static class WorldlessBlockWrapper {
        public final Block block;

        public WorldlessBlockWrapper(Block block) {
            this.block = block;
        }

        public int hashCode() {
            return (this.block.getY() + this.block.getZ() * 31) * 31 + this.block.getX();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Block)) {
                return false;
            }
            Block other = (Block)obj;
            return this.block.getX() == other.getX() && this.block.getY() == other.getY() && this.block.getZ() == other.getZ();
        }
    }
}

