/*
 * Decompiled with CFR 0.152.
 */
package eu.decentsoftware.holograms.nms;

import eu.decentsoftware.holograms.api.utils.reflect.Version;
import eu.decentsoftware.holograms.nms.api.DecentHologramsNmsException;
import eu.decentsoftware.holograms.nms.api.NmsAdapter;
import eu.decentsoftware.holograms.shared.reflect.ReflectUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Objects;

public class NmsAdapterFactory {
    public NmsAdapter createNmsAdapter(Version version) {
        Objects.requireNonNull(version, "version cannot be null");
        String nmsAdapterImplementationClassName = "eu.decentsoftware.holograms.nms." + version.name() + ".NmsAdapterImpl";
        try {
            Class<?> nmsAdapterImplementationClass = ReflectUtil.getClass(nmsAdapterImplementationClassName);
            if (!NmsAdapter.class.isAssignableFrom(nmsAdapterImplementationClass)) {
                throw new DecentHologramsNmsException("Nms adapter " + nmsAdapterImplementationClassName + " does not implement " + NmsAdapter.class.getName());
            }
            Constructor<?> constructor = nmsAdapterImplementationClass.getDeclaredConstructor(new Class[0]);
            return (NmsAdapter)constructor.newInstance(new Object[0]);
        }
        catch (DecentHologramsNmsException e) {
            throw e;
        }
        catch (ClassNotFoundException e) {
            throw new DecentHologramsNmsException("Unsupported server version: " + version.name());
        }
        catch (NoSuchMethodException e) {
            throw new DecentHologramsNmsException("NmsAdapter implementation is missing the default constructor: " + nmsAdapterImplementationClassName);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new DecentHologramsNmsException("Failed to construct a new instance of NmsAdapter implementation: " + nmsAdapterImplementationClassName, e);
        }
        catch (Exception e) {
            throw new DecentHologramsNmsException("Unknown error occurred while initializing NmsAdapter implementation: " + nmsAdapterImplementationClassName, e);
        }
    }
}

