/*
 * Decompiled with CFR 0.152.
 */
package eu.decentsoftware.holograms.nms.v1_12_R1;

import eu.decentsoftware.holograms.nms.v1_12_R1.EntityTypeRegistry;
import eu.decentsoftware.holograms.nms.v1_12_R1.PacketDataSerializerWrapper;
import eu.decentsoftware.holograms.shared.DecentPosition;
import eu.decentsoftware.holograms.shared.reflect.ReflectField;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.server.v1_12_R1.DataWatcher;
import net.minecraft.server.v1_12_R1.MathHelper;
import net.minecraft.server.v1_12_R1.Packet;
import net.minecraft.server.v1_12_R1.PacketPlayOutEntityDestroy;
import net.minecraft.server.v1_12_R1.PacketPlayOutEntityEquipment;
import net.minecraft.server.v1_12_R1.PacketPlayOutEntityMetadata;
import net.minecraft.server.v1_12_R1.PacketPlayOutEntityTeleport;
import net.minecraft.server.v1_12_R1.PacketPlayOutMount;
import net.minecraft.server.v1_12_R1.PacketPlayOutSpawnEntity;
import net.minecraft.server.v1_12_R1.PacketPlayOutSpawnEntityLiving;
import org.bukkit.craftbukkit.v1_12_R1.CraftEquipmentSlot;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_12_R1.inventory.CraftItemStack;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;

class EntityPacketsBuilder {
    private static final ReflectField<DataWatcher> SPAWN_ENTITY_LIVING_PACKET_DATA_WATCHER_FIELD = new ReflectField(PacketPlayOutSpawnEntityLiving.class, "m");
    private final List<Packet<?>> packets = new ArrayList();

    private EntityPacketsBuilder() {
    }

    void sendTo(Player player) {
        for (Packet<?> packet : this.packets) {
            this.sendPacket(player, packet);
        }
    }

    EntityPacketsBuilder withSpawnEntityLivingOrObject(int entityId, EntityType type, DecentPosition position) {
        if (type.isAlive()) {
            return this.withSpawnEntityLiving(entityId, type, position);
        }
        return this.withSpawnEntity(entityId, type, position);
    }

    EntityPacketsBuilder withSpawnEntity(int entityId, EntityType type, DecentPosition position) {
        PacketDataSerializerWrapper serializer = this.prepareSpawnEntityData(entityId, type, position);
        serializer.writeInt(type == EntityType.DROPPED_ITEM ? 1 : 0);
        serializer.writeShort(0);
        serializer.writeShort(0);
        serializer.writeShort(0);
        PacketPlayOutSpawnEntity packet = new PacketPlayOutSpawnEntity();
        serializer.writeToPacket((Packet<?>)packet);
        this.packets.add((Packet<?>)packet);
        return this;
    }

    EntityPacketsBuilder withSpawnEntityLiving(int entityId, EntityType type, DecentPosition position) {
        return this.withSpawnEntityLiving(entityId, type, position, new DataWatcher(null));
    }

    EntityPacketsBuilder withSpawnEntityLiving(int entityId, EntityType type, DecentPosition position, DataWatcher dataWatcher) {
        PacketDataSerializerWrapper serializer = this.prepareSpawnEntityData(entityId, type, position);
        serializer.writeByte(MathHelper.d((float)(position.getYaw() * 256.0f / 360.0f)));
        serializer.writeShort(0);
        serializer.writeShort(0);
        serializer.writeShort(0);
        serializer.writeByte(255);
        PacketPlayOutSpawnEntityLiving packet = new PacketPlayOutSpawnEntityLiving();
        serializer.writeToPacket((Packet<?>)packet);
        SPAWN_ENTITY_LIVING_PACKET_DATA_WATCHER_FIELD.set(packet, dataWatcher);
        this.packets.add((Packet<?>)packet);
        return this;
    }

    private PacketDataSerializerWrapper prepareSpawnEntityData(int entityId, EntityType type, DecentPosition position) {
        PacketDataSerializerWrapper serializer = PacketDataSerializerWrapper.getInstance();
        serializer.writeVarInt(entityId);
        serializer.writeUuid(UUID.randomUUID());
        serializer.writeByte(EntityTypeRegistry.getEntityTypeId(type));
        serializer.writeDouble(position.getX());
        serializer.writeDouble(position.getY());
        serializer.writeDouble(position.getZ());
        serializer.writeByte(MathHelper.d((float)(position.getYaw() * 256.0f / 360.0f)));
        serializer.writeByte(MathHelper.d((float)(position.getPitch() * 256.0f / 360.0f)));
        return serializer;
    }

    EntityPacketsBuilder withEntityMetadata(int entityId, List<DataWatcher.Item<?>> watchableObjects) {
        PacketDataSerializerWrapper serializer = PacketDataSerializerWrapper.getInstance();
        serializer.writeVarInt(entityId);
        serializer.writeWatchableObjects(watchableObjects);
        PacketPlayOutEntityMetadata packet = new PacketPlayOutEntityMetadata();
        serializer.writeToPacket((Packet<?>)packet);
        this.packets.add((Packet<?>)packet);
        return this;
    }

    EntityPacketsBuilder withHelmet(int entityId, ItemStack itemStack) {
        PacketPlayOutEntityEquipment packet = new PacketPlayOutEntityEquipment(entityId, CraftEquipmentSlot.getNMS((EquipmentSlot)EquipmentSlot.HEAD), this.itemStackToNms(itemStack));
        this.packets.add((Packet<?>)packet);
        return this;
    }

    EntityPacketsBuilder withTeleportEntity(int entityId, DecentPosition position) {
        PacketDataSerializerWrapper serializer = PacketDataSerializerWrapper.getInstance();
        serializer.writeVarInt(entityId);
        serializer.writeDouble(position.getX());
        serializer.writeDouble(position.getY());
        serializer.writeDouble(position.getZ());
        serializer.writeByte((byte)(position.getYaw() * 256.0f / 360.0f));
        serializer.writeByte((byte)(position.getPitch() * 256.0f / 360.0f));
        serializer.writeBoolean(false);
        PacketPlayOutEntityTeleport packet = new PacketPlayOutEntityTeleport();
        serializer.writeToPacket((Packet<?>)packet);
        this.packets.add((Packet<?>)packet);
        return this;
    }

    EntityPacketsBuilder withPassenger(int entityId, int passenger) {
        return this.updatePassenger(entityId, passenger);
    }

    EntityPacketsBuilder withRemovePassenger(int entityId) {
        return this.updatePassenger(entityId, -1);
    }

    private EntityPacketsBuilder updatePassenger(int entityId, int ... passengers) {
        PacketDataSerializerWrapper serializer = PacketDataSerializerWrapper.getInstance();
        serializer.writeVarInt(entityId);
        serializer.writeIntArray(passengers);
        PacketPlayOutMount packet = new PacketPlayOutMount();
        serializer.writeToPacket((Packet<?>)packet);
        this.packets.add((Packet<?>)packet);
        return this;
    }

    EntityPacketsBuilder withRemoveEntity(int entityId) {
        PacketPlayOutEntityDestroy packet = new PacketPlayOutEntityDestroy(new int[]{entityId});
        this.packets.add((Packet<?>)packet);
        return this;
    }

    private void sendPacket(Player player, Packet<?> packet) {
        ((CraftPlayer)player).getHandle().playerConnection.sendPacket(packet);
    }

    private net.minecraft.server.v1_12_R1.ItemStack itemStackToNms(ItemStack itemStack) {
        return CraftItemStack.asNMSCopy((ItemStack)itemStack);
    }

    static EntityPacketsBuilder create() {
        return new EntityPacketsBuilder();
    }
}

