/*
 * Decompiled with CFR 0.152.
 */
package eu.decentsoftware.holograms.nms.v1_9_R1;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import eu.decentsoftware.holograms.nms.v1_9_R1.EntityMetadataType;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.v1_9_R1.DataWatcher;
import net.minecraft.server.v1_9_R1.ItemStack;
import org.bukkit.craftbukkit.v1_9_R1.inventory.CraftItemStack;

class EntityMetadataBuilder {
    private final List<DataWatcher.Item<?>> watchableObjects = new ArrayList();

    private EntityMetadataBuilder() {
    }

    List<DataWatcher.Item<?>> toWatchableObjects() {
        return this.watchableObjects;
    }

    EntityMetadataBuilder withCustomName(String customName) {
        this.watchableObjects.add(EntityMetadataType.ENTITY_CUSTOM_NAME.construct(customName));
        boolean visible = !Strings.isNullOrEmpty((String)customName);
        this.watchableObjects.add(EntityMetadataType.ENTITY_CUSTOM_NAME_VISIBLE.construct(visible));
        return this;
    }

    EntityMetadataBuilder withItemStack(org.bukkit.inventory.ItemStack itemStack) {
        Optional itemStackOptional = Optional.fromNullable((Object)CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)itemStack));
        this.watchableObjects.add(EntityMetadataType.ITEM_STACK.construct((Optional<ItemStack>)itemStackOptional));
        return this;
    }

    EntityMetadataBuilder withSilent() {
        this.watchableObjects.add(EntityMetadataType.ENTITY_SILENT.construct(true));
        return this;
    }

    static EntityMetadataBuilder create() {
        return new EntityMetadataBuilder();
    }
}

