/*
 * Decompiled with CFR 0.152.
 */
package eu.decentsoftware.holograms.nms.v1_9_R2;

import eu.decentsoftware.holograms.nms.api.NmsHologramPartData;
import eu.decentsoftware.holograms.nms.api.renderer.NmsEntityHologramRenderer;
import eu.decentsoftware.holograms.nms.v1_9_R2.DataWatcherBuilder;
import eu.decentsoftware.holograms.nms.v1_9_R2.EntityIdGenerator;
import eu.decentsoftware.holograms.nms.v1_9_R2.EntityMetadataBuilder;
import eu.decentsoftware.holograms.nms.v1_9_R2.EntityPacketsBuilder;
import eu.decentsoftware.holograms.nms.v1_9_R2.EntityTypeRegistry;
import eu.decentsoftware.holograms.shared.DecentPosition;
import net.minecraft.server.v1_9_R2.DataWatcher;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;

class EntityHologramRenderer
implements NmsEntityHologramRenderer {
    private final int entityId;
    private final int armorStandEntityId;
    private final DataWatcher armorStandDataWatcher;

    EntityHologramRenderer(EntityIdGenerator entityIdGenerator) {
        this.entityId = entityIdGenerator.getFreeEntityId();
        this.armorStandEntityId = entityIdGenerator.getFreeEntityId();
        this.armorStandDataWatcher = DataWatcherBuilder.create().withInvisible().withArmorStandProperties(true, true).toDataWatcher();
    }

    @Override
    public void display(Player player, NmsHologramPartData<EntityType> data) {
        DecentPosition position = data.getPosition();
        EntityType content = data.getContent();
        DecentPosition offsetPosition = this.offsetPosition(position);
        EntityPacketsBuilder.create().withSpawnEntityLiving(this.armorStandEntityId, EntityType.ARMOR_STAND, offsetPosition, this.armorStandDataWatcher).withSpawnEntityLivingOrObject(this.entityId, content, offsetPosition).withEntityMetadata(this.entityId, EntityMetadataBuilder.create().withSilent().toWatchableObjects()).withPassenger(this.armorStandEntityId, this.entityId).sendTo(player);
    }

    @Override
    public void updateContent(Player player, NmsHologramPartData<EntityType> data) {
        DecentPosition position = data.getPosition();
        EntityType content = data.getContent();
        EntityPacketsBuilder.create().withRemovePassenger(this.armorStandEntityId).withRemoveEntity(this.entityId).withSpawnEntityLivingOrObject(this.entityId, content, position).withTeleportEntity(this.entityId, position).withPassenger(this.armorStandEntityId, this.entityId).sendTo(player);
    }

    @Override
    public void move(Player player, NmsHologramPartData<EntityType> data) {
        this.hide(player);
        this.display(player, data);
    }

    @Override
    public void hide(Player player) {
        EntityPacketsBuilder.create().withRemovePassenger(this.armorStandEntityId).withRemoveEntity(this.entityId).withRemoveEntity(this.armorStandEntityId).sendTo(player);
    }

    @Override
    public double getHeight(NmsHologramPartData<EntityType> data) {
        return EntityTypeRegistry.getEntityTypeHeight(data.getContent());
    }

    @Override
    public int[] getEntityIds() {
        return new int[]{this.entityId};
    }

    private DecentPosition offsetPosition(DecentPosition position) {
        return position.subtractY(0.25);
    }
}

