/*
 * Decompiled with CFR 0.152.
 */
package eu.decentsoftware.holograms.semver;

import org.jetbrains.annotations.NotNull;

public class SemanticVersion
implements Comparable<SemanticVersion> {
    private static final String SNAPSHOT_SUFFIX = "-SNAPSHOT";
    private final int major;
    private final int minor;
    private final int patch;
    private final boolean snapshot;

    private SemanticVersion(int major, int minor, int patch, boolean snapshot) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.snapshot = snapshot;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    public boolean isSnapshot() {
        return this.snapshot;
    }

    public String toString() {
        return this.major + "." + this.minor + "." + this.patch + (this.snapshot ? SNAPSHOT_SUFFIX : "");
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SemanticVersion)) {
            return false;
        }
        SemanticVersion that = (SemanticVersion)obj;
        return this.major == that.major && this.minor == that.minor && this.patch == that.patch && this.snapshot == that.snapshot;
    }

    public int hashCode() {
        int result = this.major;
        result = 31 * result + this.minor;
        result = 31 * result + this.patch;
        result = 31 * result + (this.snapshot ? 1 : 0);
        return result;
    }

    @Override
    public int compareTo(@NotNull SemanticVersion other) {
        if (this.major != other.major) {
            return Integer.compare(this.major, other.major);
        }
        if (this.minor != other.minor) {
            return Integer.compare(this.minor, other.minor);
        }
        if (this.patch != other.patch) {
            return Integer.compare(this.patch, other.patch);
        }
        return Boolean.compare(other.snapshot, this.snapshot);
    }

    @NotNull
    public static SemanticVersion fromString(String versionString) {
        if (versionString == null || versionString.isEmpty()) {
            throw new IllegalArgumentException("Version string cannot be null or empty");
        }
        String[] numberParts = versionString.split("\\.");
        if (numberParts.length < 3) {
            throw new IllegalArgumentException("Version string must contain at least major, minor, and patch components");
        }
        if (numberParts.length > 3) {
            throw new IllegalArgumentException("Version string must contain at most three components: major, minor, and patch");
        }
        try {
            int majorVersion = SemanticVersion.parseVersionNumber(numberParts[0], "Major version");
            int minorVersion = SemanticVersion.parseVersionNumber(numberParts[1], "Minor version");
            int patchVersion = SemanticVersion.parseVersionNumber(numberParts[2].replace(SNAPSHOT_SUFFIX, ""), "Patch version");
            boolean isSnapshot = numberParts[2].endsWith(SNAPSHOT_SUFFIX);
            return new SemanticVersion(majorVersion, minorVersion, patchVersion, isSnapshot);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid version format: " + versionString, e);
        }
    }

    private static int parseVersionNumber(String numberString, String versionPart) {
        int majorVersion = Integer.parseInt(numberString);
        if (majorVersion < 0) {
            throw new IllegalArgumentException(versionPart + " must be a non-negative integer");
        }
        return majorVersion;
    }
}

