/*
 * Decompiled with CFR 0.152.
 */
package eu.decentsoftware.holograms.skin.mojang;

import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import eu.decentsoftware.holograms.api.utils.Log;
import eu.decentsoftware.holograms.skin.SkinSource;
import eu.decentsoftware.holograms.skin.SkinSourceException;
import eu.decentsoftware.holograms.skin.mojang.MojangProfileProperty;
import eu.decentsoftware.holograms.skin.mojang.MojangProfileResponse;
import eu.decentsoftware.holograms.skin.mojang.MojangUuidResponse;
import eu.decentsoftware.holograms.url.UrlReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class MojangSkinSource
implements SkinSource {
    private static final Gson gson = new Gson();

    @Override
    @NotNull
    public String fetchSkinTextureByPlayerName(@NotNull String playerName) {
        Objects.requireNonNull(playerName, "playerName cannot be null");
        String uuid = this.fetchUniqueIdByPlayerName(playerName);
        try {
            URL url = new URL("https://sessionserver.mojang.com/session/minecraft/profile/" + uuid);
            String jsonResponse = UrlReader.readString(url);
            return this.extractSkinTextureFromJson(playerName, jsonResponse);
        }
        catch (SkinSourceException e) {
            throw e;
        }
        catch (IOException e) {
            Log.warn("Failed to fetch skin texture for player %s.", e, playerName);
            throw new SkinSourceException("Failed to fetch skin texture for player " + playerName + ".");
        }
        catch (Exception e) {
            Log.error("An unexpected error occurred while fetching skin texture for player %s.", e, playerName);
            throw new SkinSourceException("An unexpected error occurred while fetching skin texture for player " + playerName + ".");
        }
    }

    private String fetchUniqueIdByPlayerName(String playerName) {
        try {
            URL url = new URL("https://api.minecraftservices.com/minecraft/profile/lookup/name/" + playerName);
            String jsonResponse = UrlReader.readString(url);
            return this.extractUniqueIdFromJson(playerName, jsonResponse);
        }
        catch (SkinSourceException e) {
            throw e;
        }
        catch (FileNotFoundException e) {
            throw new SkinSourceException("Cannot fetch skin texture for player " + playerName + ". Player not found.");
        }
        catch (IOException e) {
            Log.warn("Failed to fetch unique ID for player %s.", e, playerName);
            throw new SkinSourceException("Failed to fetch unique ID for player " + playerName + ".");
        }
        catch (Exception e) {
            Log.error("An unexpected error occurred while fetching unique ID for player %s.", e, playerName);
            throw new SkinSourceException("An unexpected error occurred while fetching unique ID for player " + playerName + ".");
        }
    }

    private String extractUniqueIdFromJson(String playerName, String json) {
        try {
            MojangUuidResponse response = (MojangUuidResponse)gson.fromJson(json, MojangUuidResponse.class);
            String errorMessage = response.getErrorMessage();
            if (errorMessage != null) {
                Log.warn("Error fetching UUID for player: %s. Error message: %s", playerName, errorMessage);
                throw new SkinSourceException(errorMessage);
            }
            String uniqueId = response.getId();
            if (uniqueId != null && !uniqueId.isEmpty()) {
                return uniqueId;
            }
            throw new SkinSourceException("No unique ID found in JSON response: " + json);
        }
        catch (SkinSourceException e) {
            throw e;
        }
        catch (JsonSyntaxException e) {
            Log.warn("Failed to parse JSON response: %s", e, json);
            throw new SkinSourceException("Failed to parse JSON response: " + json);
        }
        catch (Exception e) {
            Log.error("An unexpected error occurred while extracting unique ID from JSON: %s", e, json);
            throw new SkinSourceException("An unexpected error occurred while extracting unique ID from JSON.");
        }
    }

    private String extractSkinTextureFromJson(String playerName, String json) {
        try {
            if (json == null || json.isEmpty()) {
                throw new SkinSourceException("Received empty JSON response while fetching skin texture for player " + playerName + ".");
            }
            MojangProfileResponse response = (MojangProfileResponse)gson.fromJson(json, MojangProfileResponse.class);
            List<MojangProfileProperty> properties = response.getProperties();
            if (properties == null || properties.isEmpty()) {
                throw new SkinSourceException("No profile properties found in JSON response: " + json);
            }
            for (MojangProfileProperty property : properties) {
                if (!"textures".equals(property.getName())) continue;
                return property.getValue();
            }
            throw new SkinSourceException("No skin texture found in JSON response: " + json);
        }
        catch (SkinSourceException e) {
            throw e;
        }
        catch (JsonParseException e) {
            Log.warn("Failed to parse JSON response: %s", e, json);
            throw new SkinSourceException("Failed to parse JSON response: " + json);
        }
        catch (Exception e) {
            Log.error("An unexpected error occurred while extracting skin texture from JSON: %s", e, json);
            throw new SkinSourceException("An unexpected error occurred while extracting skin texture from JSON.");
        }
    }
}

