/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.npc.api.pathfinding;

import de.eisi05.npc.api.pathfinding.AStar;
import de.eisi05.npc.api.pathfinding.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import org.bukkit.Location;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PathfindingUtils {
    @NotNull
    public static CompletableFuture<Path> findPathAsync(@NotNull List<Location> waypoints, int maxIterations, boolean allowDiagonalMovement, @Nullable BiConsumer<Integer, Integer> progressListener) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return PathfindingUtils.findPath(waypoints, maxIterations, allowDiagonalMovement, progressListener);
            }
            catch (AStar.InvalidPathException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @NotNull
    public static Path findPath(@NotNull List<Location> waypoints, int maxIterations, boolean allowDiagonalMovement, @Nullable BiConsumer<Integer, Integer> progressListener) throws AStar.InvalidPathException {
        ArrayList<CompletableFuture<List>> futures = new ArrayList<CompletableFuture<List>>();
        int i = 0;
        while (i < waypoints.size() - 1) {
            int idx = i++;
            futures.add(CompletableFuture.supplyAsync(() -> {
                try {
                    AStar aStar = new AStar((Location)waypoints.get(idx), (Location)waypoints.get(idx + 1), maxIterations, allowDiagonalMovement);
                    List<Location> segment = aStar.iterate().stream().map(tile -> tile.getLocation(aStar.getStart()).add(0.5, 1.0, 0.5)).toList();
                    if (progressListener != null) {
                        progressListener.accept(idx + 1, waypoints.size());
                    }
                    return segment;
                }
                catch (AStar.InvalidPathException e) {
                    throw new RuntimeException(e);
                }
            }));
        }
        Path path = new Path(futures.stream().map(CompletableFuture::join).flatMap(Collection::stream).toList(), waypoints);
        if (progressListener != null) {
            progressListener.accept(waypoints.size(), waypoints.size());
        }
        return path;
    }
}

