/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.npc.plugin.listeners;

import de.eisi05.npc.api.objects.NPC;
import de.eisi05.npc.api.objects.NpcHolder;
import de.eisi05.npc.plugin.manager.ConversationManager;
import de.eisi05.npc.plugin.utils.Prefix;
import java.io.IOException;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.InventoryHolder;

public class InventoryListener
implements Listener {
    @EventHandler
    public void onClose(InventoryCloseEvent event) {
        InventoryHolder inventoryHolder = event.getView().getTopInventory().getHolder();
        if (!(inventoryHolder instanceof NpcHolder)) {
            return;
        }
        NpcHolder npcHolder = (NpcHolder)inventoryHolder;
        if (event.getPlayer().getItemOnCursor() != null) {
            event.getPlayer().setItemOnCursor(null);
        }
        if (!npcHolder.hasUnsavedChanges()) {
            return;
        }
        try {
            npcHolder.save();
        }
        catch (IOException e) {
            event.getPlayer().sendMessage(Prefix.PREFIX.append(Component.text((String)"Error while trying to save NPC!").color((TextColor)NamedTextColor.RED)));
            throw new RuntimeException(e);
        }
    }

    @EventHandler
    public void onClick(InventoryClickEvent event) {
        String npcPlain;
        InventoryHolder inventoryHolder = event.getView().getTopInventory().getHolder();
        if (!(inventoryHolder instanceof NPC)) {
            return;
        }
        NPC npc = (NPC)inventoryHolder;
        if (event.getSlotType() == InventoryType.SlotType.OUTSIDE) {
            event.setCancelled(true);
            event.getWhoClicked().setItemOnCursor(null);
            return;
        }
        if (event.getCursor() == null) {
            return;
        }
        if (!event.getClickedInventory().equals((Object)event.getView().getBottomInventory())) {
            return;
        }
        Component title = event.getView().title();
        Component npcName = npc.getName();
        String titlePlain = PlainTextComponentSerializer.plainText().serialize(title);
        if (titlePlain.equals(npcPlain = PlainTextComponentSerializer.plainText().serialize(npcName))) {
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler
    public void onDrag(InventoryDragEvent event) {
        if (!(event.getView().getTopInventory().getHolder() instanceof NpcHolder)) {
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler
    public void onOpen(InventoryOpenEvent event) {
        if (ConversationManager.activeConversations.containsKey(event.getPlayer().getUniqueId())) {
            event.setCancelled(true);
        }
    }
}

