/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.npc.plugin.listeners;

import de.eisi05.npc.api.events.NpcInteractEvent;
import de.eisi05.npc.plugin.gui.NpcGUI;
import de.eisi05.npc.plugin.manager.ConversationManager;
import de.eisi05.npc.plugin.manager.EditManager;
import de.eisi05.npc.plugin.utils.LocalizedMessage;
import de.eisi05.npc.plugin.utils.builder.InventoryBuilder;
import org.bukkit.Sound;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;

public class NpcInteractListener
implements Listener {
    @EventHandler(priority=EventPriority.HIGHEST)
    public void onInteract(NpcInteractEvent event) {
        if (ConversationManager.activeConversations.containsKey(event.getPlayer().getUniqueId())) {
            event.setCancelled(true);
            return;
        }
        if (!event.getPlayer().hasPermission("npc.admin")) {
            return;
        }
        if (!EditManager.isEditing(event.getPlayer())) {
            return;
        }
        if (!event.getNpc().isEditable()) {
            LocalizedMessage.sendMessage(event.getPlayer(), "misc.interact.not-editable", true, new Object[0]);
            return;
        }
        NpcGUI.getInventory(event.getNpc(), event.getPlayer(), false).open((HumanEntity)event.getPlayer(), new InventoryBuilder.Animation(InventoryBuilder.AnimationType.UP, 1, Sound.BLOCK_NOTE_BLOCK_HAT));
        event.setCancelled(true);
    }
}

