/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.npc.plugin.objects;

import de.eisi05.npc.api.NpcApi;
import de.eisi05.npc.api.interfaces.NpcClickAction;
import de.eisi05.npc.api.utils.Var;
import de.eisi05.npc.plugin.NpcPlugin;
import de.eisi05.npc.plugin.gui.NpcGUI;
import de.eisi05.npc.plugin.manager.ConversationManager;
import de.eisi05.npc.plugin.manager.LocalizationManager;
import de.eisi05.npc.plugin.objects.AbstractPluginActionOption;
import de.eisi05.npc.plugin.objects.NpcClickActionImpl;
import de.eisi05.npc.plugin.utils.LocalizedMessage;
import de.eisi05.npc.plugin.utils.Prefix;
import de.eisi05.npc.plugin.utils.builder.ItemBuilder;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public final class ServerActionOption
extends AbstractPluginActionOption<String> {
    private static final long serialVersionUID = 1L;

    private ServerActionOption() {
    }

    @NotNull
    static NpcClickActionImpl.PluginActionOptions<String> getServerAction() {
        return ServerActionOption.getOption(ServerActionOption.class, ServerActionOption::new);
    }

    @Override
    String getName() {
        return "server";
    }

    @Override
    String getDefaultValue() {
        return null;
    }

    @Override
    NpcClickAction getAction(String s) {
        return e -> {
            if (s == null || s.isBlank()) {
                return;
            }
            try {
                ByteArrayOutputStream bb = new ByteArrayOutputStream();
                DataOutputStream out = new DataOutputStream(bb);
                out.writeUTF("Connect");
                out.writeUTF(s);
                e.getPlayer().sendPluginMessage((Plugin)NpcPlugin.plugin, "BungeeCord", bb.toByteArray());
                LocalizedMessage.sendMessage(e.getPlayer(), "actions.server.connecting", true, s);
            }
            catch (Exception ex) {
                LocalizedMessage.sendMessage(e.getPlayer(), "actions.server.failed", true, s);
                NpcPlugin.plugin.getLogger().severe("BungeeCord Connect Error: " + ex.getMessage());
            }
        };
    }

    @Override
    ItemBuilder getIcon(String s, Player player) {
        return new ItemBuilder(Material.ENDER_PEARL).addLore(s == null || s.isEmpty() ? LocalizationManager.get(player, "actions.server.value", LocalizationManager.get(player, "misc.not-set", new Object[0])) : LocalizationManager.get(player, "actions.server.value", s));
    }

    @Override
    String getClickAction(String currentServer, final NpcClickActionImpl.PluginActionOptions.PluginActionData data) {
        Player player = (Player)data.event().getWhoClicked();
        player.playSound(player.getLocation(), Sound.ITEM_BOOK_PAGE_TURN, 1.0f, 1.2f);
        data.event().getWhoClicked().closeInventory();
        ConversationManager conversation = new ConversationManager((Plugin)NpcPlugin.plugin).withEscapeSequence(LocalizationManager.getAsString(player, "actions.server.input.abort-sequence", new Object[0])).withTimeout(NpcApi.config.inputTime()).addConversationAbandonedListener(event -> {
            Player p = event.player();
            if (!event.gracefulExit()) {
                p.playSound(p.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                if ("timeout".equals(event.reason())) {
                    LocalizedMessage.sendMessage(p, "actions.server.input.timeout", true, NpcApi.config.inputTime());
                } else {
                    LocalizedMessage.sendMessage(p, "actions.server.input.cancelled", true, new Object[0]);
                }
            }
            Bukkit.getScheduler().runTask((Plugin)NpcPlugin.plugin, () -> p.openInventory(NpcGUI.getActionInventory(data.clickActionType(), data.npc(), p, data.withTeleport())));
        });
        ConversationManager.Prompt serverPrompt = new ConversationManager.Prompt(){

            @Override
            public Component getPromptText(Player p) {
                return Prefix.PREFIX.append(LocalizationManager.get(p, "actions.server.input.prompt", new Object[0]));
            }

            @Override
            public ConversationManager.Prompt onInput(Player p, String input) {
                if (input == null || input.trim().isEmpty()) {
                    p.playSound(p.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                    LocalizedMessage.sendMessage(p, "actions.server.input.empty", true, new Object[0]);
                    return this;
                }
                data.actionInstance().param = (Serializable)Var.unsafeCast(input);
                data.npc().markChange();
                p.playSound(p.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.2f);
                LocalizedMessage.sendMessage(p, "actions.server.set", true, input);
                return null;
            }
        };
        conversation.startConversation(player, serverPrompt);
        return currentServer;
    }
}

