/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.npc.plugin.utils;

import de.eisi05.npc.plugin.NpcPlugin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class ItemConfiguration {
    private static final Class<?>[] classes = new Class[]{String.class, Short.class, Long.class, Byte.class, Double.class, Integer.class, Byte[].class, Float.class, Integer[].class, Long[].class, PersistentDataContainer.class, PersistentDataContainer[].class};
    private static final PersistentDataType[] types = new PersistentDataType[]{PersistentDataType.STRING, PersistentDataType.SHORT, PersistentDataType.LONG, PersistentDataType.BYTE, PersistentDataType.DOUBLE, PersistentDataType.INTEGER, PersistentDataType.BYTE_ARRAY, PersistentDataType.FLOAT, PersistentDataType.INTEGER_ARRAY, PersistentDataType.LONG_ARRAY, PersistentDataType.TAG_CONTAINER};

    public static <Z> ItemStack setData(ItemStack item, String key, Z value) {
        ItemMeta meta = item.getItemMeta();
        PersistentDataContainer container = meta.getPersistentDataContainer();
        container.set(new NamespacedKey((Plugin)NpcPlugin.plugin, key), ItemConfiguration.getType(value), value);
        item.setItemMeta(meta);
        return item;
    }

    public static <Z> Z getData(ItemStack item, String key) {
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return null;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        if (ItemConfiguration.hasData(item, key)) {
            return (Z)container.get(new NamespacedKey((Plugin)NpcPlugin.plugin, key), ItemConfiguration.getType(new NamespacedKey((Plugin)NpcPlugin.plugin, key), container));
        }
        return null;
    }

    public static List<String> getKeys(ItemStack item) {
        ItemMeta meta = item.getItemMeta();
        PersistentDataContainer container = meta.getPersistentDataContainer();
        ArrayList<String> list = new ArrayList<String>();
        for (NamespacedKey key : container.getKeys()) {
            if (!key.getNamespace().equalsIgnoreCase(NpcPlugin.plugin.getName())) continue;
            list.add(key.getKey());
        }
        return list;
    }

    public static void removeData(ItemStack item, String key) {
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        container.remove(new NamespacedKey((Plugin)NpcPlugin.plugin, key));
        item.setItemMeta(meta);
    }

    public static void clearData(ItemStack item) {
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        container.getKeys().forEach(arg_0 -> ((PersistentDataContainer)container).remove(arg_0));
        item.setItemMeta(meta);
    }

    public static boolean hasData(ItemStack item, String key) {
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return false;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        for (NamespacedKey s : container.getKeys()) {
            if (!s.getKey().equalsIgnoreCase(key)) continue;
            return true;
        }
        return false;
    }

    public static void removeAllData(ItemStack item) {
        for (String key : ItemConfiguration.getKeys(item)) {
            ItemConfiguration.removeData(item, key);
        }
    }

    public static void updatePlugin(ItemStack item) {
        ItemMeta meta = item.getItemMeta();
        PersistentDataContainer container = meta.getPersistentDataContainer();
        for (NamespacedKey s : container.getKeys()) {
            if (s.getNamespace().equalsIgnoreCase(NpcPlugin.plugin.getName())) continue;
            NamespacedKey nK = new NamespacedKey((Plugin)NpcPlugin.plugin, s.getKey());
            container.set(nK, ItemConfiguration.getType(s, container), container.get(s, ItemConfiguration.getType(s, container)));
            container.remove(s);
            item.setItemMeta(meta);
        }
    }

    private static PersistentDataType getType(NamespacedKey namespacedKey, PersistentDataContainer container) {
        for (PersistentDataType type : types) {
            if (!container.has(namespacedKey, type)) continue;
            return type;
        }
        return null;
    }

    private static <Z> PersistentDataType getType(Z value) {
        for (Class<?> c : classes) {
            if (!c.equals(value.getClass())) continue;
            return types[Arrays.asList(classes).indexOf(c)];
        }
        return null;
    }

    public <Z> Z getOrDefault(ItemStack item, String key, Z defaultData) {
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return defaultData;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        if (ItemConfiguration.hasData(item, key)) {
            return (Z)container.get(new NamespacedKey((Plugin)NpcPlugin.plugin, key), ItemConfiguration.getType(new NamespacedKey((Plugin)NpcPlugin.plugin, key), container));
        }
        return defaultData;
    }
}

