/*
 * Decompiled with CFR 0.152.
 */
package com.skytechbytes.playerstatuebuilder;

import com.skytechbytes.playerstatuebuilder.PlayerStatueBuilderException;
import java.util.HashSet;
import java.util.List;

public class StatueArgs {
    private float hue = -1.0f;
    private float saturation = -1.0f;
    private float contrast = -1.0f;
    private float brightness = -1.0f;
    private float posterize = -1.0f;
    private String direction = "";
    private int x;
    private int y;
    private int z;
    private String world = "";
    private HashSet<String> flags = new HashSet();
    private HashSet<String> assigned = new HashSet();

    public StatueArgs(List<String> tokens) throws Exception {
        try {
            for (String token : tokens) {
                String[] tokenized = token.split(":");
                this.assigned.add(tokenized[0]);
                if (tokenized.length == 2) {
                    if (tokenized[0].equalsIgnoreCase("hue")) {
                        this.hue = Float.parseFloat(tokenized[1]);
                        continue;
                    }
                    if (tokenized[0].equalsIgnoreCase("saturation")) {
                        this.saturation = Float.parseFloat(tokenized[1]);
                        continue;
                    }
                    if (tokenized[0].equalsIgnoreCase("contrast")) {
                        this.contrast = Float.parseFloat(tokenized[1]);
                        continue;
                    }
                    if (tokenized[0].equalsIgnoreCase("brightness")) {
                        this.brightness = Float.parseFloat(tokenized[1]);
                        continue;
                    }
                    if (tokenized[0].equalsIgnoreCase("posterize")) {
                        this.posterize = Float.parseFloat(tokenized[1]);
                        continue;
                    }
                    if (tokenized[0].equalsIgnoreCase("x")) {
                        this.x = Integer.parseInt(tokenized[1]);
                        continue;
                    }
                    if (tokenized[0].equalsIgnoreCase("y")) {
                        this.y = Integer.parseInt(tokenized[1]);
                        continue;
                    }
                    if (tokenized[0].equalsIgnoreCase("z")) {
                        this.z = Integer.parseInt(tokenized[1]);
                        continue;
                    }
                    if (tokenized[0].equalsIgnoreCase("direction")) {
                        this.direction = tokenized[1];
                        continue;
                    }
                    if (tokenized[0].equalsIgnoreCase("world")) {
                        this.world = tokenized[1];
                        continue;
                    }
                    this.flags.add(tokenized[0]);
                    continue;
                }
                if (tokenized.length == 0) {
                    throw new PlayerStatueBuilderException("Invalid ':' parameter");
                }
                this.flags.add(tokenized[0]);
            }
        }
        catch (NumberFormatException nfe) {
            throw new PlayerStatueBuilderException(nfe.getMessage());
        }
    }

    public float getHue() {
        return this.hue;
    }

    public float getSaturation() {
        return this.saturation;
    }

    public float getContrast() {
        return this.contrast;
    }

    public float getBrightness() {
        return this.brightness;
    }

    public float getPosterize() {
        return this.posterize;
    }

    public String getDirection() {
        return this.direction;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public String getWorld() {
        return this.world;
    }

    public boolean hasFlag(String flag) {
        return this.flags.contains(flag);
    }

    public boolean isSet(String value) {
        return this.assigned.contains(value);
    }
}

