/*
 * Decompiled with CFR 0.152.
 */
package com.skytechbytes.playerstatuebuilder;

import com.skytechbytes.playerstatuebuilder.Log;
import com.skytechbytes.playerstatuebuilder.PlayerStatueBuilder;
import java.io.File;
import java.util.ArrayList;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;

public class StatueConfiguration {
    private final Plugin p = PlayerStatueBuilder.instance;

    public void createConfig() {
        try {
            File file;
            if (!this.p.getDataFolder().exists()) {
                this.p.getDataFolder().mkdirs();
            }
            if (!(file = new File(this.p.getDataFolder(), "config.yml")).exists()) {
                Log.log("Config.yml not found, creating!");
                this.loadDefaultConfigFile();
            } else {
                Log.log("Config.yml found, loading!");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadDefaultConfigFile() {
        FileConfiguration c = this.p.getConfig();
        ArrayList<String> headerContents = new ArrayList<String>();
        headerContents.add("PlayerStatueBuilderX Configuration File");
        c.options().setHeader(headerContents);
        c.addDefault("rate", (Object)16);
        c.addDefault("cooldown", (Object)1);
        c.addDefault("charge", (Object)"DIAMOND");
        c.addDefault("exact", (Object)false);
        c.addDefault("priceRate", (Object)0);
        c.options().copyDefaults(true);
        this.p.saveConfig();
        this.p.reloadConfig();
    }
}

