/*
 * Decompiled with CFR 0.152.
 */
package com.skytechbytes.playerstatuebuilder;

import com.skytechbytes.playerstatuebuilder.APIWrapper;
import com.skytechbytes.playerstatuebuilder.Log;
import com.skytechbytes.playerstatuebuilder.PlayerStatueBuilder;
import com.skytechbytes.playerstatuebuilder.PlayerStatueBuilderException;
import com.skytechbytes.playerstatuebuilder.builder.ImageUtil;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;

public class Util {
    private static final Map<String, BufferedImage> cache = new ConcurrentHashMap<String, BufferedImage>();

    public static BufferedImage getSkinImage(String name) throws Exception {
        BufferedImage bi = null;
        bi = !cache.containsKey(name) ? (Util.isDiskSkin(name) ? Util.getDiskSkinImage(name) : Util.getCloudSkinImage(name)) : cache.get(name);
        return bi;
    }

    public static boolean isDiskSkin(String name) {
        return name.startsWith(".") && name.length() > 1;
    }

    public static BufferedImage getDiskSkinImage(String name) throws Exception {
        BufferedImage bi = null;
        Object fileName = name.substring(1);
        Pattern pattern = Pattern.compile("[^a-zA-Z0-9]");
        boolean hasSpecialChar = pattern.matcher((CharSequence)fileName).find();
        if (hasSpecialChar) {
            throw new PlayerStatueBuilderException("Admins: make sure your skin image is alphanumeric only; Your skin name can't have a special character (don't include .png).");
        }
        if (!((String)fileName).endsWith(".png") && !((String)fileName).endsWith(".PNG")) {
            fileName = (String)fileName + ".png";
        }
        try {
            Path customFile = Paths.get(PlayerStatueBuilder.instance.getDataFolder().toURI().resolve((String)fileName));
            bi = ImageIO.read(customFile.toFile());
            bi = Util.convertToARGB(bi);
            if (bi == null) {
                throw new PlayerStatueBuilderException("");
            }
        }
        catch (Exception e) {
            throw new PlayerStatueBuilderException("Unable to load file from plugin data folder. Make sure the name is spelled correctly and the skin image file is in the same folder as the config file.");
        }
        return ImageUtil.deepCopy(bi);
    }

    public static BufferedImage convertToARGB(BufferedImage originalImage) {
        BufferedImage argbImage = new BufferedImage(originalImage.getWidth(), originalImage.getHeight(), 2);
        Graphics2D g2d = argbImage.createGraphics();
        g2d.drawImage((Image)originalImage, 0, 0, null);
        g2d.dispose();
        return argbImage;
    }

    private static String getUUID(String name) throws Exception {
        String uuid = "";
        try {
            String json = APIWrapper.readJsonFromUrl("https://playerdb.co/api/player/minecraft/" + name);
            uuid = json.substring(json.indexOf("raw_id\":") + 9, json.indexOf("raw_id\":") + 9 + 32);
            Log.log(uuid);
        }
        catch (Exception e) {
            throw new PlayerStatueBuilderException("Failed to lookup uuid, likely because player specified does not exist.");
        }
        return uuid;
    }

    public static BufferedImage getCloudSkinImage(String name) throws Exception {
        String[] endpoints;
        BufferedImage bi;
        try {
            URL url1 = new URL("https://mineskin.eu/download/" + name);
            bi = ImageIO.read(url1);
            if (bi != null) {
                return ImageUtil.deepCopy(bi);
            }
        }
        catch (IOException e) {
            Log.log("Could not obtain skin from mineskin.eu");
        }
        String uuid = Util.getUUID(name);
        for (String endpoint : endpoints = new String[]{"https://mc-heads.net/download/", "https://crafatar.com/skins/"}) {
            try {
                URL url = new URL(endpoint + uuid);
                bi = ImageIO.read(url);
                if (bi == null) continue;
                return ImageUtil.deepCopy(bi);
            }
            catch (IOException e) {
                Log.log("Could not obtain skin from " + endpoint);
            }
        }
        throw new PlayerStatueBuilderException("Could not obtain skin from the API or backup API. Please try again later.");
    }
}

