/*
 * Decompiled with CFR 0.152.
 */
package com.skytechbytes.playerstatuebuilder.builder;

import com.skytechbytes.playerstatuebuilder.Log;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import javax.imageio.ImageIO;

public class AssetManager {
    public static HashMap<String, BufferedImage> armor = new HashMap();
    public static HashMap<String, BufferedImage> items = new HashMap();
    private static final String[] armor_materials = new String[]{"chainmail", "iron", "golden", "diamond"};

    public static void initialize() {
        for (String material : armor_materials) {
            AssetManager.load(material + "_armor", armor);
            AssetManager.load(material + "_helmet", armor, material + "_armor", new Rectangle(32, 0, 32, 16));
            AssetManager.load(material + "_chestplate", armor, material + "_armor", new Rectangle(16, 32, 48, 32));
            AssetManager.load(material + "_boots", armor, material + "_armor", new Rectangle(0, 32, 16, 32));
        }
    }

    public static void load(String name, HashMap<String, BufferedImage> group) {
        try {
            String file = "/" + name + ".png";
            Log.log("Loading texture " + file);
            group.put(name, ImageIO.read(AssetManager.class.getResourceAsStream(file)));
        }
        catch (Exception e) {
            Log.log("Failed to load texture " + name + ". Restart the server to fix.");
        }
    }

    public static void load(String name, HashMap<String, BufferedImage> group, String baseImage, Rectangle ... subregions) {
        try {
            BufferedImage base = group.get(baseImage);
            if (base == null) {
                return;
            }
            BufferedImage subImage = new BufferedImage(base.getWidth(), base.getHeight(), 2);
            Graphics g = subImage.getGraphics();
            for (Rectangle region : subregions) {
                g.drawImage(base.getSubimage((int)region.getX(), (int)region.getY(), (int)region.getWidth(), (int)region.getHeight()), (int)region.getX(), (int)region.getY(), null);
            }
            g.dispose();
            group.put(name, subImage);
        }
        catch (Exception e) {
            Log.log("Failed to load texture " + name);
        }
    }
}

