/*
 * Decompiled with CFR 0.152.
 */
package com.skytechbytes.playerstatuebuilder.builder;

import com.skytechbytes.playerstatuebuilder.builder.BuildUtils;
import com.skytechbytes.playerstatuebuilder.builder.Schematic;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;

public class FaceBuilder {
    public static int master_orientation = 2;
    public static int minor_orientation = 3;
    public Schematic statue;

    public FaceBuilder(Schematic s) {
        this.statue = s;
    }

    public void buildFace(Location o, Material[][] matrix, int orientation) {
        this.buildFace(o, matrix, orientation, 0, 0, 0, false, false);
    }

    public void buildFace(Location o, Material[][] matrix, int orientation, int off1, int off2, int off3) {
        this.buildFace(o, matrix, orientation, off1, off2, off3, false, false);
    }

    public void buildFace(Location o, Material[][] matrix, int orientation, int off1, int off2, int off3, boolean flipH, boolean flipV) {
        World w = o.getWorld();
        if (matrix == null) {
            return;
        }
        if (flipH) {
            BuildUtils.flipHorizontal(matrix);
        }
        if (flipV) {
            BuildUtils.flipVertical(matrix);
        }
        for (int y = 0; y < matrix.length; ++y) {
            block16: for (int x = 0; x < matrix[y].length; ++x) {
                if (master_orientation == 0) {
                    switch (orientation) {
                        case 0: {
                            this.gba(w, o, x + off1, -y + matrix.length + off2, off3, matrix[y][x]);
                            break;
                        }
                        case 1: {
                            this.gba(w, o, x + off1, off2, y + off3, matrix[y][x]);
                            break;
                        }
                        case 2: {
                            this.gba(w, o, off1, -y + matrix.length + off2, x + off3, matrix[y][x]);
                        }
                    }
                    continue;
                }
                if (master_orientation == 1) {
                    switch (orientation) {
                        case 0: {
                            this.gba(w, o, off3, off1 + x, -y + matrix.length + off2, matrix[y][x]);
                            break;
                        }
                        case 1: {
                            this.gba(w, o, y + off3, off1 + x, off2, matrix[y][x]);
                            break;
                        }
                        case 2: {
                            this.gba(w, o, x + off3, off1, -y + matrix.length + off2, matrix[y][x]);
                        }
                    }
                    continue;
                }
                if (master_orientation != 2) continue;
                switch (orientation) {
                    case 0: {
                        this.gba(w, o, -y + matrix.length + off2, off3, off1 + x, matrix[y][x]);
                        continue block16;
                    }
                    case 1: {
                        this.gba(w, o, off2, y + off3, off1 + x, matrix[y][x]);
                        continue block16;
                    }
                    case 2: {
                        this.gba(w, o, -y + matrix.length + off2, x + off3, off1, matrix[y][x]);
                    }
                }
            }
        }
    }

    private void gba(World w, Location o, int off1, int off2, int off3, Material m) {
        switch (minor_orientation) {
            case 0: {
                this.ll(w, o.getBlockX() + off1, o.getBlockY() + off2, o.getBlockZ() + off3, m);
                break;
            }
            case 1: {
                this.ll(w, o.getBlockX() - off1, o.getBlockY() + off2, o.getBlockZ() - off3, m);
                break;
            }
            case 2: {
                this.ll(w, o.getBlockX() + off3, o.getBlockY() + off2, o.getBlockZ() - off1, m);
                break;
            }
            case 3: {
                this.ll(w, o.getBlockX() - off3, o.getBlockY() + off2, o.getBlockZ() + off1, m);
            }
        }
    }

    private void ll(World w, int off1, int off2, int off3, Material m) {
        this.statue.setBlockAt(off1, off2, off3, m);
    }
}

