/*
 * Decompiled with CFR 0.152.
 */
package com.skytechbytes.playerstatuebuilder.builder;

import com.jhlabs.image.ContrastFilter;
import com.jhlabs.image.HSBAdjustFilter;
import com.jhlabs.image.PosterizeFilter;
import com.jhlabs.image.SaturationFilter;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;

public class ImageUtil {
    public static BufferedImage overlayImage(BufferedImage below, BufferedImage above) {
        BufferedImage newImage = new BufferedImage(below.getWidth(), below.getHeight(), 2);
        Graphics2D g = newImage.createGraphics();
        g.drawImage((Image)below, 0, 0, null);
        g.drawImage((Image)above, (below.getWidth() - above.getWidth()) / 2, (below.getHeight() - above.getHeight()) / 2, null);
        g.dispose();
        return newImage;
    }

    public static BufferedImage deepCopy(BufferedImage source) {
        BufferedImage b = new BufferedImage(source.getWidth(), source.getHeight(), source.getType());
        Graphics2D g = b.createGraphics();
        g.drawImage((Image)source, 0, 0, null);
        g.dispose();
        return b;
    }

    public static BufferedImage toRGB(Image i) {
        BufferedImage rgb = new BufferedImage(i.getWidth(null), i.getHeight(null), 2);
        rgb.createGraphics().drawImage(i, 0, 0, null);
        return rgb;
    }

    public static BufferedImage applyFilters(BufferedImage bi, float contrast, float brightness, float saturation, float hue, float posterize) {
        ContrastFilter cf;
        if (contrast != -1.0f) {
            ImageUtil.checkParams("contrast", contrast, 0.0f, 1.0f);
            cf = new ContrastFilter();
            cf.setContrast(contrast);
            bi = cf.filter(bi, null);
        }
        if (brightness != -1.0f) {
            ImageUtil.checkParams("brightness", brightness, 0.0f, 1.0f);
            cf = new ContrastFilter();
            cf.setBrightness(brightness);
            bi = cf.filter(bi, null);
        }
        if (saturation != -1.0f) {
            ImageUtil.checkParams("saturation", saturation, 0.0f, 1.0f);
            SaturationFilter sf = new SaturationFilter();
            sf.setAmount(saturation);
            bi = sf.filter(bi, null);
        }
        if (hue != -1.0f) {
            ImageUtil.checkParams("hue", hue, 0.0f, 1.0f);
            HSBAdjustFilter hsb = new HSBAdjustFilter();
            hsb.setHFactor(hue);
            bi = hsb.filter(bi, null);
        }
        if (posterize != -1.0f) {
            ImageUtil.checkParams("posterize", posterize, 0.0f, 128.0f);
            PosterizeFilter p = new PosterizeFilter();
            p.setNumLevels(Math.round(posterize));
            bi = p.filter(bi, null);
        }
        return bi;
    }

    private static void checkParams(String name, float in, float low, float high) throws IllegalArgumentException {
        if (in < low || in > high) {
            throw new IllegalArgumentException("Parameter " + name + " must be in the range " + low + " to " + high);
        }
    }
}

