/*
 * Decompiled with CFR 0.152.
 */
package com.skytechbytes.playerstatuebuilder.builder;

import com.skytechbytes.playerstatuebuilder.Log;
import com.skytechbytes.playerstatuebuilder.PlayerStatueBuilder;
import com.skytechbytes.playerstatuebuilder.PlayerStatueBuilderException;
import com.skytechbytes.playerstatuebuilder.StatueArgs;
import com.skytechbytes.playerstatuebuilder.builder.SchematicUtil;
import com.skytechbytes.playerstatuebuilder.builder.StatueMaker;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class PlayerStatueMaker
extends StatueMaker {
    public static HashMap<String, Long> cooldowns = new HashMap();
    private final Player p;
    private final boolean quote;

    public PlayerStatueMaker(Player p, String mode, BufferedImage bi, boolean quote, StatueArgs params) {
        super(new Location(p.getLocation().getWorld(), (double)p.getLocation().getBlockX(), (double)(p.getLocation().getBlockY() + 3), (double)p.getLocation().getBlockZ()), PlayerStatueMaker.getDirection(p.getLocation().getYaw()), mode, bi, params);
        this.p = p;
        this.quote = quote;
    }

    private static String getDirection(double rot) {
        if (rot < 0.0) {
            rot += 360.0;
        }
        if (0.0 <= rot && rot < 45.0) {
            return "North";
        }
        if (45.0 <= rot && rot < 135.0) {
            return "East";
        }
        if (135.0 <= rot && rot < 225.0) {
            return "South";
        }
        if (225.0 <= rot && rot < 315.0) {
            return "West";
        }
        if (315.0 <= rot && rot <= 360.0) {
            return "North";
        }
        Log.log("The Player's direction is somehow negative or greater than 360. Might want to report this.");
        return "North";
    }

    public boolean hasCooldown(Player p) {
        if (p.hasPermission("playerstatuebuilderx.noWait")) {
            return false;
        }
        if (cooldowns.get(p.getName()) == null) {
            return false;
        }
        if (cooldowns.get(p.getName()) < System.currentTimeMillis()) {
            return false;
        }
        long timeLeft = cooldowns.get(p.getName()) - System.currentTimeMillis();
        long min = timeLeft / 60000L;
        long sec = timeLeft % 60000L / 1000L;
        p.sendMessage(ChatColor.RED + "You've created a statue recently. Please wait at least " + min + " minutes and " + sec + " seconds.");
        return true;
    }

    @Override
    protected void generateStatueSchematic() throws Exception {
        if ((this.getParams().hasFlag("xy") || this.getParams().hasFlag("xz") || this.getParams().hasFlag("yz")) && !this.p.hasPermission("playerstatuebuilderx.specialOrientations")) {
            this.p.sendMessage(ChatColor.RED + "You are not allowed to issue this command with xy|xz|yz. Omit that term and run it again.");
            throw new PlayerStatueBuilderException("Insufficient Permissions");
        }
        super.generateStatueSchematic();
    }

    @Override
    protected void createStatue() {
        if (this.quote) {
            SchematicUtil.query(this.getSchematic(), this.p);
            return;
        }
        boolean canBuild = SchematicUtil.canBuild(this.getSchematic(), this.p);
        if (!canBuild) {
            this.p.sendMessage(ChatColor.RED + "Insufficient build permissions. Move to a place where you're allowed to build.");
            return;
        }
        if (this.hasCooldown(this.p)) {
            return;
        }
        Log.log("Trying to remove items...");
        boolean takeMaterials = SchematicUtil.removeItemsOrAlert(this.getSchematic(), this.p);
        if (!takeMaterials) {
            Log.log("Insufficient materials");
            return;
        }
        Log.log("Creating Structure...");
        this.getSchematic().createSchematic(false, !this.p.hasPermission("playerstatuebuilderx.override"));
        cooldowns.put(this.p.getName(), System.currentTimeMillis() + (long)PlayerStatueBuilder.instance.getConfig().getInt("cooldown") * 60000L);
        this.p.sendMessage(ChatColor.GREEN + "Statue Created!");
    }

    @Override
    public void run() {
        try {
            if (this.getImage() == null) {
                throw new PlayerStatueBuilderException("Failed to obtain that player's skin. Please check spelling or try again later.");
            }
            super.generateStatueSchematic();
            this.createStatue();
        }
        catch (PlayerStatueBuilderException psbe) {
            this.p.sendMessage(ChatColor.RED + "Error! " + psbe.getMessage());
        }
        catch (Exception e) {
            this.p.sendMessage(ChatColor.RED + "Error! " + e.getMessage());
            e.printStackTrace();
        }
    }
}

